/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.MaxLength;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.RegEx;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.TitleFacetFormattedByRegex;
import org.apache.isis.core.metamodel.facets.param.parameter.fileaccept.FileAcceptFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetInvertedByNullableAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetInvertedByOptionalAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.maxlen.MaxLengthFacetForMaxLengthAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.maxlen.MaxLengthFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mustsatisfy.MustSatisfySpecificationFacetForMustSatisfyAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.mustsatisfy.MustSatisfySpecificationFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetFromRegExAnnotationOnParameter;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForConflictingOptionality;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class ParameterAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation maxLengthValidator = new MetaModelValidatorForDeprecatedAnnotation(MaxLength.class);
    private final MetaModelValidatorForDeprecatedAnnotation mustSatisfyValidator = new MetaModelValidatorForDeprecatedAnnotation(MustSatisfy.class);
    private final MetaModelValidatorForDeprecatedAnnotation regexValidator = new MetaModelValidatorForDeprecatedAnnotation(RegEx.class);
    private final MetaModelValidatorForDeprecatedAnnotation optionalValidator = new MetaModelValidatorForDeprecatedAnnotation(Optional.class);
    private final MetaModelValidatorForConflictingOptionality conflictingOptionalityValidator = new MetaModelValidatorForConflictingOptionality();

    public ParameterAnnotationFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        if (paramNum >= (parameterTypes = method.getParameterTypes()).length) {
            return;
        }
        this.processParamsMaxLength(processParameterContext);
        this.processParamsMustSatisfy(processParameterContext);
        this.processParamsRegEx(processParameterContext);
        this.processParamsOptional(processParameterContext);
        this.processParamsFileAccept(processParameterContext);
    }

    void processParamsMaxLength(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            if (!(parameterAnnotation instanceof MaxLength)) continue;
            MaxLength annotation = (MaxLength)parameterAnnotation;
            MaxLengthFacet facet = MaxLengthFacetForMaxLengthAnnotationOnParameter.create(annotation, processParameterContext.getFacetHolder());
            FacetUtil.addFacet(this.maxLengthValidator.flagIfPresent(facet, processParameterContext));
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            FacetUtil.addFacet(MaxLengthFacetForParameterAnnotation.create(parameter, holder));
            return;
        }
    }

    void processParamsMustSatisfy(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            if (!(parameterAnnotation instanceof MustSatisfy)) continue;
            MustSatisfy annotation = (MustSatisfy)parameterAnnotation;
            Facet facet = MustSatisfySpecificationFacetForMustSatisfyAnnotationOnParameter.create(annotation, processParameterContext.getFacetHolder(), this.servicesInjector);
            FacetUtil.addFacet(this.mustSatisfyValidator.flagIfPresent(facet, processParameterContext));
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            FacetUtil.addFacet(MustSatisfySpecificationFacetForParameterAnnotation.create(parameter, holder, this.servicesInjector));
            return;
        }
    }

    void processParamsRegEx(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            Class<?> parameterType = parameterTypes[paramNum];
            if (!(parameterAnnotation instanceof RegEx)) continue;
            RegEx annotation = (RegEx)parameterAnnotation;
            RegExFacet facet = RegExFacetFromRegExAnnotationOnParameter.create(annotation, parameterType, holder);
            FacetUtil.addFacet(this.regexValidator.flagIfPresent(facet, processParameterContext));
            RegExFacet regExFacet = facet;
            if (regExFacet != null) {
                FacetUtil.addFacet(new TitleFacetFormattedByRegex(regExFacet));
            }
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            Class<?> parameterType = parameterTypes[paramNum];
            FacetUtil.addFacet(RegExFacetForParameterAnnotation.create(parameter, parameterType, holder));
            return;
        }
    }

    void processParamsOptional(FacetFactory.ProcessParameterContext processParameterContext) {
        MandatoryFacet facet;
        Optional annotation;
        Class<?> parameterType;
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            parameterType = parameterTypes[paramNum];
            if (!(parameterAnnotation instanceof Optional)) continue;
            annotation = (Optional)parameterAnnotation;
            FacetUtil.addFacet(this.optionalValidator.flagIfPresent(MandatoryFacetInvertedByOptionalAnnotationOnParameter.create(annotation, parameterType, holder), processParameterContext));
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            parameterType = parameterTypes[paramNum];
            if (!(parameterAnnotation instanceof Nullable)) continue;
            annotation = (Nullable)parameterAnnotation;
            facet = MandatoryFacetInvertedByNullableAnnotationOnParameter.create((Nullable)annotation, parameterType, holder);
            FacetUtil.addFacet(facet);
            this.conflictingOptionalityValidator.flagIfConflict(facet, "Conflicting @Nullable with other optionality annotation");
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            Class<?> parameterType2 = parameterTypes[paramNum];
            facet = MandatoryFacetForParameterAnnotation.create(parameter, parameterType2, holder);
            FacetUtil.addFacet(facet);
            this.conflictingOptionalityValidator.flagIfConflict(facet, "Conflicting @Parameter#optionality with other optionality annotation");
        }
    }

    void processParamsFileAccept(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            FacetUtil.addFacet(FileAcceptFacetForParameterAnnotation.create(parameter, holder));
            return;
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.maxLengthValidator);
        metaModelValidator.add(this.mustSatisfyValidator);
        metaModelValidator.add(this.regexValidator);
        metaModelValidator.add(this.optionalValidator);
        metaModelValidator.add(this.conflictingOptionalityValidator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.maxLengthValidator.setConfiguration(configuration);
        this.mustSatisfyValidator.setConfiguration(configuration);
        this.regexValidator.setConfiguration(configuration);
        this.optionalValidator.setConfiguration(configuration);
    }
}

