/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.bigdecimal.javaxvaldigits;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import javax.validation.constraints.Digits;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.param.bigdecimal.javaxvaldigits.BigDecimalFacetOnParameterFromJavaxValidationDigitsAnnotation;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;

public class BigDecimalFacetOnParameterFromJavaxValidationAnnotationFactory
extends FacetFactoryAbstract {
    public BigDecimalFacetOnParameterFromJavaxValidationAnnotationFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        if (BigDecimal.class != method.getParameterTypes()[paramNum]) {
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            if (!(parameterAnnotation instanceof Digits)) continue;
            Digits digitsAnnotation = (Digits)parameterAnnotation;
            FacetUtil.addFacet(this.create(digitsAnnotation, (FacetHolder)processParameterContext.getFacetHolder()));
            return;
        }
    }

    private BigDecimalValueFacet create(Digits annotation, FacetHolder holder) {
        int length = annotation.integer() + annotation.fraction();
        int scale = annotation.fraction();
        return annotation == null ? null : new BigDecimalFacetOnParameterFromJavaxValidationDigitsAnnotation(holder, length, scale);
    }
}

