/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value;

import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.adapters.Parser2;
import org.apache.isis.applib.adapters.ValueSemanticsProvider;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facets.MultipleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacetUsingDefaultsProvider;
import org.apache.isis.core.metamodel.facets.object.encodeable.encoder.EncodableFacetUsingEncoderDecoder;
import org.apache.isis.core.metamodel.facets.object.parseable.parser.ParseableFacetUsingParser;
import org.apache.isis.core.metamodel.facets.object.title.parser.TitleFacetUsingParser;
import org.apache.isis.core.metamodel.facets.object.value.EqualByContentFacetViaValueSemantics;
import org.apache.isis.core.metamodel.facets.object.value.ImmutableFacetViaValueSemantics;
import org.apache.isis.core.metamodel.facets.object.value.MaxLengthFacetUsingParser2;
import org.apache.isis.core.metamodel.facets.object.value.TypicalLengthFacetUsingParser;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class ValueFacetAbstract
extends MultipleValueFacetAbstract
implements ValueFacet {
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private final ValueSemanticsProvider<?> semanticsProvider;
    private final ServicesInjector servicesInjector;

    public static Class<? extends Facet> type() {
        return ValueFacet.class;
    }

    private static ValueSemanticsProvider<?> newValueSemanticsProviderOrNull(Class<?> semanticsProviderClass, FacetHolder holder, ServicesInjector servicesInjector) {
        if (semanticsProviderClass == null) {
            return null;
        }
        return (ValueSemanticsProvider)ClassExtensions.newInstance(semanticsProviderClass, new Class[]{FacetHolder.class, ServicesInjector.class}, new Object[]{holder, servicesInjector});
    }

    public ValueFacetAbstract(Class<?> semanticsProviderClass, AddFacetsIfInvalidStrategy addFacetsIfInvalid, FacetHolder holder, ServicesInjector servicesInjector) {
        this(ValueFacetAbstract.newValueSemanticsProviderOrNull(semanticsProviderClass, holder, servicesInjector), addFacetsIfInvalid, holder, servicesInjector);
    }

    public ValueFacetAbstract(ValueSemanticsProvider<?> semanticsProvider, AddFacetsIfInvalidStrategy addFacetsIfInvalid, FacetHolder holder, ServicesInjector servicesInjector) {
        super(ValueFacetAbstract.type(), holder);
        boolean equalByContent;
        boolean immutable;
        this.semanticsProvider = semanticsProvider;
        this.servicesInjector = servicesInjector;
        if (!this.isValid() && !addFacetsIfInvalid.shouldAddFacetsIfInvalid()) {
            return;
        }
        this.facetHolder.addFacet((Facet)this);
        boolean bl = immutable = semanticsProvider == null || semanticsProvider.isImmutable();
        if (immutable) {
            this.facetHolder.addFacet(new ImmutableFacetViaValueSemantics(holder));
        }
        boolean bl2 = equalByContent = semanticsProvider == null || semanticsProvider.isEqualByContent();
        if (equalByContent) {
            this.facetHolder.addFacet(new EqualByContentFacetViaValueSemantics(holder));
        }
        if (semanticsProvider != null) {
            DefaultsProvider defaultsProvider;
            Parser parser;
            EncoderDecoder encoderDecoder = semanticsProvider.getEncoderDecoder();
            if (encoderDecoder != null) {
                this.facetHolder.addFacet(new EncodableFacetUsingEncoderDecoder(encoderDecoder, holder, this.getAdapterMap(), this.servicesInjector));
            }
            if ((parser = semanticsProvider.getParser()) != null) {
                Parser2 parser2;
                Integer maxLength;
                this.facetHolder.addFacet(new ParseableFacetUsingParser(parser, holder, this.servicesInjector));
                this.facetHolder.addFacet(new TitleFacetUsingParser(parser, holder, this.servicesInjector));
                this.facetHolder.addFacet(new TypicalLengthFacetUsingParser(parser, holder, this.servicesInjector));
                if (parser instanceof Parser2 && (maxLength = (parser2 = (Parser2)parser).maxLength()) != null) {
                    this.facetHolder.addFacet(new MaxLengthFacetUsingParser2(parser2, holder, this.servicesInjector));
                }
            }
            if ((defaultsProvider = semanticsProvider.getDefaultsProvider()) != null) {
                this.facetHolder.addFacet(new DefaultedFacetUsingDefaultsProvider(defaultsProvider, holder, this.servicesInjector));
            }
        }
    }

    public boolean isValid() {
        return this.semanticsProvider != null;
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return this.facetHolder.getFacetTypes();
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facetType) {
        return this.facetHolder.getFacet(facetType);
    }

    @Override
    public boolean containsFacetTypeOf(Class<? extends Facet> requiredFacetType) {
        for (Class<? extends Facet> facetType : this.facetTypes()) {
            if (facetType != requiredFacetType) continue;
            return true;
        }
        return false;
    }

    protected DeploymentCategory getDeploymentCategory(ServicesInjector servicesInjector) {
        return servicesInjector.getDeploymentCategoryProvider().getDeploymentCategory();
    }

    private AdapterManager getAdapterMap() {
        return this.servicesInjector.getPersistenceSessionServiceInternal();
    }

    public static enum AddFacetsIfInvalidStrategy {
        DO_ADD(true),
        DONT_ADD(false);

        private boolean addFacetsIfInvalid;

        private AddFacetsIfInvalidStrategy(boolean addFacetsIfInvalid) {
            this.addFacetsIfInvalid = addFacetsIfInvalid;
        }

        public boolean shouldAddFacetsIfInvalid() {
            return this.addFacetsIfInvalid;
        }
    }
}

