/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable.parser;

import java.util.IllegalFormatException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.adapters.ParsingException;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.interactions.ParseValueContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ParseableFacetUsingParser
extends FacetAbstract
implements ParseableFacet {
    private final Parser<?> parser;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesInjector dependencyInjector;
    private final AdapterManager adapterManager;

    public ParseableFacetUsingParser(Parser<?> parser, FacetHolder holder, ServicesInjector servicesInjector) {
        super(ParseableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parser = parser;
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
        this.dependencyInjector = servicesInjector;
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }

    @Override
    protected String toStringValues() {
        this.dependencyInjector.injectServicesInto(this.parser);
        return this.parser.toString();
    }

    @Override
    public ObjectAdapter parseTextEntry(ObjectAdapter contextAdapter, String entry, InteractionInitiatedBy interactionInitiatedBy) {
        if (entry == null) {
            throw new IllegalArgumentException("An entry must be provided");
        }
        if (this.getFacetHolder().containsFacet(ValueFacet.class)) {
            ObjectAdapter entryAdapter = this.getAdapterManager().adapterFor(entry);
            Identifier identifier = this.getIdentified().getIdentifier();
            ParseValueContext parseValueContext = new ParseValueContext(contextAdapter, identifier, entryAdapter, interactionInitiatedBy);
            this.validate(parseValueContext);
        }
        Object context = ObjectAdapter.Util.unwrap(contextAdapter);
        this.getDependencyInjector().injectServicesInto(this.parser);
        try {
            Object parsed = this.parser.parseTextEntry(context, entry);
            if (parsed == null) {
                return null;
            }
            ObjectAdapter adapter = this.getAdapterManager().adapterFor(parsed);
            ObjectSpecification specification = adapter.getSpecification();
            ObjectValidityContext validateContext = specification.createValidityInteractionContext(adapter, interactionInitiatedBy);
            this.validate(validateContext);
            return adapter;
        }
        catch (NumberFormatException | IllegalFormatException | ParsingException e) {
            throw new TextEntryParseException(e.getMessage(), e);
        }
    }

    private void validate(ValidityContext<?> validityContext) {
        InteractionResultSet resultSet = new InteractionResultSet();
        InteractionUtils.isValidResultSet(this.getFacetHolder(), validityContext, resultSet);
        if (resultSet.isVetoed()) {
            throw new IllegalArgumentException(resultSet.getInteractionResult().getReason());
        }
    }

    @Override
    public String parseableTitle(ObjectAdapter contextAdapter) {
        Object pojo = ObjectAdapter.Util.unwrap(contextAdapter);
        this.getDependencyInjector().injectServicesInto(this.parser);
        return this.parser.parseableTitleOf(pojo);
    }

    public ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

