/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.parseable.ParserUtil;
import org.apache.isis.core.metamodel.facets.object.parseable.annotcfg.ParseableFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.parseable.annotcfg.ParseableFacetFromConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

public class ParseableFacetAnnotationElseConfigurationFactory
extends FacetFactoryAbstract {
    PersistenceSessionServiceInternal adapterManager;

    public ParseableFacetAnnotationElseConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet(this.create(processClassContaxt.getCls(), (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    private ParseableFacetAbstract create(Class<?> cls, FacetHolder holder) {
        ParseableFacetFromConfiguration facet;
        ParseableFacetAnnotation facet2;
        Parseable annotation = Annotations.getAnnotation(cls, Parseable.class);
        if (annotation != null && (facet2 = new ParseableFacetAnnotation(cls, this.getConfiguration(), holder, (AdapterManager)this.adapterManager, this.servicesInjector)).isValid()) {
            return facet2;
        }
        String parserName = ParserUtil.parserNameFromConfiguration(cls, this.getConfiguration());
        if (!Strings.isNullOrEmpty((String)parserName) && (facet = new ParseableFacetFromConfiguration(parserName, holder, this.servicesInjector, this.adapterManager)).isValid()) {
            return facet;
        }
        return null;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

