/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.mixin;

import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.mixin.MetaModelValidatorForMixinTypes;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacetForMixinAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;

public class MixinFacetForMixinAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForMixinTypes mixinTypeValidator = new MetaModelValidatorForMixinTypes("@Mixin");

    public MixinFacetForMixinAnnotationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> candidateMixinType = processClassContext.getCls();
        Mixin mixinAnnotation = candidateMixinType.getAnnotation(Mixin.class);
        if (mixinAnnotation == null) {
            return;
        }
        if (!this.mixinTypeValidator.ensureMixinType(candidateMixinType)) {
            return;
        }
        Object facetHolder = processClassContext.getFacetHolder();
        MixinFacet mixinFacet = MixinFacetForMixinAnnotation.create(candidateMixinType, facetHolder, this.servicesInjector);
        facetHolder.addFacet(mixinFacet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.mixinTypeValidator);
    }
}

