/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.immutable;

import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.WhenValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;

public abstract class ImmutableFacetAbstract
extends WhenValueFacetAbstract
implements ImmutableFacet {
    public static Class<? extends Facet> type() {
        return ImmutableFacet.class;
    }

    public ImmutableFacetAbstract(When value, FacetHolder holder) {
        super(ImmutableFacetAbstract.type(), holder, value);
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        ObjectAdapter target = ic.getTarget();
        switch (ic.getInteractionType()) {
            case PROPERTY_MODIFY: 
            case COLLECTION_ADD_TO: 
            case COLLECTION_REMOVE_FROM: {
                return this.disabledReason(target);
            }
        }
        return null;
    }

    public String disabledReason(ObjectAdapter targetAdapter) {
        if (this.when() == When.ALWAYS) {
            return "Always immmutable";
        }
        if (this.when() == When.NEVER) {
            return null;
        }
        if (targetAdapter == null) {
            return null;
        }
        if (this.when() == When.UNTIL_PERSISTED) {
            return targetAdapter.isTransient() ? "Immutable until persisted" : null;
        }
        if (this.when() == When.ONCE_PERSISTED) {
            return targetAdapter.representsPersistent() ? "Immutable once persisted" : null;
        }
        return null;
    }
}

