/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.datanucleus;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.ignore.javalang.RemoveMethodsFacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class RemoveDatanucleusPersistableTypesFacetFactory
extends FacetFactoryAbstract {
    private final List<RemoveMethodsFacetFactory.MethodAndParameterTypes> datanucleusPersistableMethodsToIgnore = Lists.newArrayList();

    public RemoveDatanucleusPersistableTypesFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
        String typeToIgnoreIfOnClasspath = "org.datanucleus.enhancement.Persistable";
        try {
            Class<?> typeToIgnore = InstanceUtil.loadClass("org.datanucleus.enhancement.Persistable");
            this.addMethodsToBeIgnored(typeToIgnore);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMethodsToBeIgnored(Class<?> typeToIgnore) {
        Method[] methods;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.datanucleusPersistableMethodsToIgnore.add(new RemoveMethodsFacetFactory.MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (RemoveMethodsFacetFactory.MethodAndParameterTypes mapt : this.datanucleusPersistableMethodsToIgnore) {
            processClassContext.removeMethod(MethodScope.OBJECT, mapt.methodName, null, mapt.methodParameters);
        }
    }
}

