/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainservice.annotation;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.annotation.DomainServiceFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainservice.annotation.IconFacetDerivedFromDomainServiceAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForValidationFailures;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class DomainServiceFacetAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public static final String ISIS_REFLECTOR_VALIDATOR_SERVICE_ACTIONS_ONLY_KEY = "isis.reflector.validator.serviceActionsOnly";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_SERVICE_ACTIONS_ONLY_DEFAULT = false;
    public static final String ISIS_REFLECTOR_VALIDATOR_MIXINS_ONLY_KEY = "isis.reflector.validator.mixinsOnly";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_MIXINS_ONLY_DEFAULT = false;
    private MetaModelValidatorForValidationFailures mixinOnlyValidator = new MetaModelValidatorForValidationFailures();

    public DomainServiceFacetAnnotationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainService annotation = Annotations.getAnnotation(cls, DomainService.class);
        if (annotation == null) {
            return;
        }
        Object facetHolder = processClassContext.getFacetHolder();
        DomainServiceFacetAnnotation domainServiceFacet = new DomainServiceFacetAnnotation((FacetHolder)facetHolder, annotation.repositoryFor(), annotation.nature());
        FacetUtil.addFacet(domainServiceFacet);
        FacetUtil.addFacet(new IconFacetDerivedFromDomainServiceAnnotation((FacetHolder)facetHolder, annotation.repositoryFor()));
        switch (domainServiceFacet.getNatureOfService()) {
            case VIEW: {
                this.mixinOnlyValidator.addFailure("%s: menu/contributed services (nature == VIEW) are prohibited ('%s' config property); convert into a mixin (@Mixin annotation) instead", cls.getName(), ISIS_REFLECTOR_VALIDATOR_MIXINS_ONLY_KEY);
                break;
            }
            case VIEW_CONTRIBUTIONS_ONLY: {
                this.mixinOnlyValidator.addFailure("%s: contributed services (nature == VIEW_CONTRIBUTIONS_ONLY) are prohibited ('%s' config property); convert into a mixin (@Mixin annotation) instead", cls.getName(), ISIS_REFLECTOR_VALIDATOR_MIXINS_ONLY_KEY);
            }
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        boolean mixinsOnly;
        boolean serviceActionsOnly = configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_SERVICE_ACTIONS_ONLY_KEY, false);
        if (serviceActionsOnly) {
            metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

                @Override
                public boolean visit(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                    this.validate(thisSpec, validationFailures);
                    return true;
                }

                private void validate(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                    if (!thisSpec.containsFacet(DomainServiceFacet.class)) {
                        return;
                    }
                    ArrayList associationNames = Lists.newArrayList();
                    List<ObjectAssociation> associations = thisSpec.getAssociations(Contributed.EXCLUDED);
                    for (ObjectAssociation association : associations) {
                        String associationName = association.getName();
                        if ("Id".equalsIgnoreCase(associationName)) continue;
                        associationNames.add(associationName);
                    }
                    if (associationNames.isEmpty()) {
                        return;
                    }
                    validationFailures.add("%s: services can only have actions ('%s' config property), not properties or collections; annotate with @Programmatic if required.  Found: %s", thisSpec.getFullIdentifier(), DomainServiceFacetAnnotationFactory.ISIS_REFLECTOR_VALIDATOR_SERVICE_ACTIONS_ONLY_KEY, Joiner.on((String)", ").join((Iterable)associationNames));
                }
            }));
        }
        if (mixinsOnly = configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_MIXINS_ONLY_KEY, false)) {
            metaModelValidator.add(this.mixinOnlyValidator);
        }
    }
}

