/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainservice;

import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.core.commons.compare.SequenceCompare;

public class DomainServiceMenuOrder {
    private DomainServiceMenuOrder() {
    }

    public static String orderOf(Class<?> cls) {
        DomainService domainService = cls.getAnnotation(DomainService.class);
        DomainServiceLayout domainServiceLayout = cls.getAnnotation(DomainServiceLayout.class);
        String dsOrder = domainService != null ? domainService.menuOrder() : null;
        String dslayoutOrder = domainServiceLayout != null ? domainServiceLayout.menuOrder() : null;
        String min = DomainServiceMenuOrder.minimumOf(dslayoutOrder, dsOrder);
        return min != null ? min : "2147483547";
    }

    private static String minimumOf(String dslayoutOrder, String dsOrder) {
        if (DomainServiceMenuOrder.isUndefined(dslayoutOrder)) {
            return dsOrder;
        }
        if (DomainServiceMenuOrder.isUndefined(dsOrder)) {
            return dslayoutOrder;
        }
        return SequenceCompare.compareNullLast(dslayoutOrder, dsOrder) < 0 ? dslayoutOrder : dsOrder;
    }

    private static boolean isUndefined(String str) {
        return str == null || str.equals("2147483547");
    }
}

