/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import java.util.Map;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.services.eventbus.CssClassUiEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.util.EventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent
extends FacetAbstract
implements CssClassFacet {
    private static final Logger LOG = LoggerFactory.getLogger(CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent.class);
    private final Class<? extends CssClassUiEvent<?>> cssClassUiEventClass;
    private final EventBusService eventBusService;

    public static Facet create(DomainObjectLayout domainObjectLayout, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        if (domainObjectLayout == null) {
            return null;
        }
        Class cssClassUiEventClass = domainObjectLayout.cssClassUiEvent();
        if (!EventUtil.eventTypeIsPostable(cssClassUiEventClass, CssClassUiEvent.Noop.class, CssClassUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.cssClassUiEvent.postForDefault", configuration)) {
            return null;
        }
        EventBusService eventBusService = servicesInjector.lookupService(EventBusService.class);
        return new CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent(cssClassUiEventClass, eventBusService, facetHolder);
    }

    public CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent(Class<? extends CssClassUiEvent<?>> cssClassUiEventClass, EventBusService eventBusService, FacetHolder holder) {
        super(CssClassFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.cssClassUiEventClass = cssClassUiEventClass;
        this.eventBusService = eventBusService;
    }

    @Override
    public String cssClass(ObjectAdapter owningAdapter) {
        Facet underlyingFacet;
        CssClassUiEvent<Object> cssClassUiEvent = this.newCssClassUiEvent(owningAdapter);
        this.eventBusService.post(cssClassUiEvent);
        String cssClass = cssClassUiEvent.getCssClass();
        if (cssClass == null && (underlyingFacet = this.getUnderlyingFacet()) instanceof CssClassFacet) {
            CssClassFacet underlyingCssClassFacet = (CssClassFacet)underlyingFacet;
            return underlyingCssClassFacet.cssClass(owningAdapter);
        }
        return cssClass;
    }

    private CssClassUiEvent<Object> newCssClassUiEvent(ObjectAdapter owningAdapter) {
        Object domainObject = owningAdapter.getObject();
        return this.newCssClassUiEvent(domainObject);
    }

    private CssClassUiEvent<Object> newCssClassUiEvent(Object domainObject) {
        try {
            CssClassUiEvent<?> cssClassUiEvent = this.cssClassUiEventClass.newInstance();
            cssClassUiEvent.setSource(domainObject);
            return cssClassUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("cssClassUiEventClass", this.cssClassUiEventClass);
    }
}

