/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.publishing;

import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.PublishingPayloadFactoryForObject;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishObjectsConfiguration;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacetAbstract;

public class PublishedObjectFacetForDomainObjectAnnotation
extends PublishedObjectFacetAbstract {
    public static PublishedObjectFacet create(DomainObject domainObject, IsisConfiguration configuration, FacetHolder holder) {
        Publishing publishing = domainObject != null ? domainObject.publishing() : Publishing.AS_CONFIGURED;
        switch (publishing) {
            case AS_CONFIGURED: {
                PublishObjectsConfiguration setting = PublishObjectsConfiguration.parse(configuration);
                switch (setting) {
                    case NONE: {
                        return null;
                    }
                }
                PublishingPayloadFactoryForObject publishingPayloadFactory = PublishedObjectFacetForDomainObjectAnnotation.newPayloadFactory(domainObject);
                return domainObject != null ? new PublishedObjectFacetForDomainObjectAnnotationAsConfigured(publishingPayloadFactory, holder) : new PublishedObjectFacetFromConfiguration(publishingPayloadFactory, holder);
            }
            case DISABLED: {
                return null;
            }
            case ENABLED: {
                return new PublishedObjectFacetForDomainObjectAnnotation(PublishedObjectFacetForDomainObjectAnnotation.newPayloadFactory(domainObject), holder);
            }
        }
        return null;
    }

    protected static PublishingPayloadFactoryForObject newPayloadFactory(DomainObject domainObject) {
        if (domainObject == null) {
            return null;
        }
        Class value = domainObject.publishingPayloadFactory();
        if (value == null) {
            return null;
        }
        try {
            return (PublishingPayloadFactoryForObject)value.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    PublishedObjectFacetForDomainObjectAnnotation(PublishingPayloadFactoryForObject publishingPayloadFactory, FacetHolder holder) {
        super(publishingPayloadFactory, holder);
    }
}

