/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.editing;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.EditingObjectsConfiguration;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacetAbstract;

public class ImmutableFacetForDomainObjectAnnotation
extends ImmutableFacetAbstract {
    private final String reason;

    public static ImmutableFacet create(DomainObject domainObject, IsisConfiguration configuration, FacetHolder holder) {
        Editing editing = domainObject != null ? domainObject.editing() : Editing.AS_CONFIGURED;
        String disabledReason = domainObject != null ? domainObject.editingDisabledReason() : "Disabled";
        switch (editing) {
            case AS_CONFIGURED: {
                if (holder.containsDoOpFacet(ImmutableFacet.class)) {
                    return null;
                }
                EditingObjectsConfiguration setting = EditingObjectsConfiguration.parse(configuration);
                return setting == EditingObjectsConfiguration.FALSE ? (domainObject != null ? new ImmutableFacetForDomainObjectAnnotationAsConfigured(disabledReason, holder) : new ImmutableFacetFromConfiguration(disabledReason, holder)) : null;
            }
            case DISABLED: {
                return new ImmutableFacetForDomainObjectAnnotation(disabledReason, holder);
            }
            case ENABLED: {
                return null;
            }
        }
        return null;
    }

    public ImmutableFacetForDomainObjectAnnotation(String reason, FacetHolder holder) {
        super(When.ALWAYS, holder);
        this.reason = reason;
    }

    @Override
    public String disabledReason(ObjectAdapter targetAdapter) {
        return !Strings.isNullOrEmpty((String)this.reason) ? this.reason : super.disabledReason(targetAdapter);
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        ImmutableFacetForDomainObjectAnnotation facet = new ImmutableFacetForDomainObjectAnnotation(this.reason, holder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("reason", this.reason);
    }
}

