/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.disabled.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.disabled.DisabledObjectFacet;
import org.apache.isis.core.metamodel.facets.object.disabled.method.DisabledObjectFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class DisabledObjectFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String DISABLED_PREFIX = "disabled";
    private static final String[] PREFIXES = new String[]{"disabled"};

    public DisabledObjectFacetViaMethodFactory() {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Class[] paramTypes = new Class[]{Identifier.Type.class};
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, DISABLED_PREFIX, new Class[]{String.class, TranslatableString.class}, paramTypes);
        if (method == null) {
            return;
        }
        TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class);
        String translationContext = ((IdentifiedHolder)facetHolder).getIdentifier().toClassIdentityString();
        FacetUtil.addFacet(new DisabledObjectFacetViaMethod(method, translationService, translationContext, (FacetHolder)facetHolder));
        processClassContext.removeMethod(method);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod member = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> owningClass = processMethodContext.getCls();
        ObjectSpecification owningSpec = this.getSpecificationLoader().loadSpecification(owningClass);
        DisabledObjectFacet facet = owningSpec.getFacet(DisabledObjectFacet.class);
        if (facet != null) {
            facet.copyOnto(member);
        }
    }
}

