/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.disabled.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.disabled.DisabledObjectFacetAbstract;

public class DisabledObjectFacetViaMethod
extends DisabledObjectFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private TranslationService translationService;
    private final String translationContext;

    public DisabledObjectFacetViaMethod(Method method, TranslationService translationService, String translationContext, FacetHolder holder) {
        super(holder);
        this.method = method;
        this.translationService = translationService;
        this.translationContext = translationContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_DISABLED;
    }

    @Override
    public String disabledReason(ObjectAdapter owningAdapter, Identifier identifier) {
        Identifier.Type type = identifier.getType();
        Object returnValue = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, type);
        if (returnValue instanceof String) {
            return (String)returnValue;
        }
        if (returnValue instanceof TranslatableString) {
            TranslatableString ts = (TranslatableString)returnValue;
            return ts.translate(this.translationService, this.translationContext);
        }
        return null;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        DisabledObjectFacetViaMethod clonedFacet = new DisabledObjectFacetViaMethod(this.method, this.translationService, this.translationContext, holder);
        FacetUtil.addFacet(clonedFacet);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("method", this.method);
    }
}

