/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.choices;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.choices.ChoicesFacet;
import org.apache.isis.core.metamodel.interactions.DisablingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public abstract class ChoicesFacetFromBoundedAbstract
extends FacetAbstract
implements ChoicesFacet,
DisablingInteractionAdvisor,
ValidatingInteractionAdvisor {
    private final DeploymentCategory deploymentCategory;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public static Class<? extends Facet> type() {
        return ChoicesFacet.class;
    }

    public ChoicesFacetFromBoundedAbstract(FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, PersistenceSessionServiceInternal persistenceSessionServiceInternal) {
        super(ChoicesFacetFromBoundedAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.deploymentCategory = deploymentCategory;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.persistenceSessionServiceInternal = persistenceSessionServiceInternal;
    }

    public PersistenceSessionServiceInternal getPersistenceSessionService() {
        return this.persistenceSessionServiceInternal;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> context) {
        if (!(context instanceof ObjectValidityContext)) {
            return null;
        }
        ObjectAdapter target = context.getTarget();
        if (target == null) {
            return null;
        }
        if (!(this.getFacetHolder() instanceof ObjectSpecification)) {
            return null;
        }
        ObjectSpecification objectSpec = this.getObjectSpecification();
        return objectSpec == target.getSpecification() ? null : "Invalid type";
    }

    private ObjectSpecification getObjectSpecification() {
        return (ObjectSpecification)this.getFacetHolder();
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> context) {
        ObjectAdapter target = context.getTarget();
        return this.disabledReason(target);
    }

    public String disabledReason(ObjectAdapter inObject) {
        return "Bounded";
    }

    @Override
    public Object[] getChoices(ObjectAdapter adapter, InteractionInitiatedBy interactionInitiatedBy) {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getObjectSpecification().getFullIdentifier(), new long[0]);
        List<ObjectAdapter> allInstancesAdapter = this.getPersistenceSessionService().allMatchingQuery(query);
        List<ObjectAdapter> adapters = ObjectAdapter.Util.visibleAdapters(allInstancesAdapter, interactionInitiatedBy);
        List pojos = Lists.transform(adapters, ObjectAdapter.Functions.getObject());
        return Lists.newArrayList((Iterable)pojos).toArray();
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }
}

