/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.bookmarkable;

import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Bookmarkable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacetFallback;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.bookmarkable.BookmarkPolicyFacetViaBookmarkableAnnotation;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class BookmarkPolicyFacetViaBookmarkableAnnotationElseFallbackFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(Bookmarkable.class);

    public BookmarkPolicyFacetViaBookmarkableAnnotationElseFallbackFactory() {
        super(FeatureType.OBJECTS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Bookmarkable annotation = Annotations.getAnnotation(processClassContext.getCls(), Bookmarkable.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processClassContext.getFacetHolder(), null));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Bookmarkable annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Bookmarkable.class);
        BookmarkPolicyFacet facet = this.create(annotation, (FacetHolder)processMethodContext.getFacetHolder(), processMethodContext);
        FacetUtil.addFacet(facet);
    }

    private BookmarkPolicyFacet create(Bookmarkable annotation, FacetHolder holder, FacetFactory.ProcessMethodContext processMethodContext) {
        return annotation == null ? new BookmarkPolicyFacetFallback(holder) : (BookmarkPolicyFacetAbstract)this.validator.flagIfPresent(new BookmarkPolicyFacetViaBookmarkableAnnotation(annotation.value(), holder), processMethodContext);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Class<?> cls = objectSpec.getCorrespondingClass();
                List<ObjectAction> objectActions = objectSpec.getObjectActions(Contributed.EXCLUDED);
                for (ObjectAction objectAction : objectActions) {
                    ActionSemanticsFacet semanticsFacet;
                    BookmarkPolicyFacet bookmarkFacet = objectAction.getFacet(BookmarkPolicyFacet.class);
                    if (bookmarkFacet == null || bookmarkFacet.isNoop() || bookmarkFacet.value() == BookmarkPolicy.NEVER || (semanticsFacet = objectAction.getFacet(ActionSemanticsFacet.class)) != null && !semanticsFacet.isNoop() && ((ActionSemantics.Of)semanticsFacet.value()).isSafeInNature()) continue;
                    validationFailures.add("%s: action is bookmarkable but action semantics are not explicitly indicated as being safe.  Either add @Action(semantics=SemanticsOf.SAFE) or @Action(semantics=SemanticsOf.SAFE_AND_REQUEST_CACHEABLE), or remove @ActionLayout(bookmarking=...).", objectAction.getIdentifier().toClassAndNameIdentityString());
                }
                return true;
            }
        }));
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.validator.setConfiguration(configuration);
    }
}

