/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.disabled;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetAbstract;

public abstract class DisabledFacetAbstractImpl
extends DisabledFacetAbstract {
    private final String reason;

    public DisabledFacetAbstractImpl(When when, Where where, FacetHolder holder) {
        this(when, where, null, holder);
    }

    public DisabledFacetAbstractImpl(When when, Where where, FacetHolder holder, DisabledFacetAbstract.Semantics semantics) {
        this(when, where, null, holder, semantics);
    }

    public DisabledFacetAbstractImpl(When when, Where where, String reason, FacetHolder holder) {
        super(when, where, holder);
        this.reason = reason;
    }

    public DisabledFacetAbstractImpl(When when, Where where, String reason, FacetHolder holder, DisabledFacetAbstract.Semantics semantics) {
        super(when, where, holder, semantics);
        this.reason = reason;
    }

    @Override
    public String disabledReason(ObjectAdapter targetAdapter) {
        if (this.when() == When.ALWAYS) {
            return this.disabledReasonElse("Always disabled");
        }
        if (this.when() == When.NEVER) {
            return null;
        }
        if (targetAdapter == null) {
            return null;
        }
        if (this.when() == When.UNTIL_PERSISTED) {
            return targetAdapter.isTransient() ? this.disabledReasonElse("Disabled until persisted") : null;
        }
        if (this.when() == When.ONCE_PERSISTED) {
            return targetAdapter.representsPersistent() ? this.disabledReasonElse("Disabled once persisted") : null;
        }
        return null;
    }

    private String disabledReasonElse(String defaultReason) {
        return !Strings.isNullOrEmpty((String)this.reason) ? this.reason : defaultReason;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("reason", this.reason);
    }
}

