/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.disabled;

import java.util.Map;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.WhenAndWhereValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.interactions.ActionUsabilityContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationContributee;

public abstract class DisabledFacetAbstract
extends WhenAndWhereValueFacetAbstract
implements DisabledFacet {
    private final Semantics semantics;

    public static Class<? extends Facet> type() {
        return DisabledFacet.class;
    }

    public DisabledFacetAbstract(When when, Where where, FacetHolder holder) {
        this(when, where, holder, Semantics.DISABLED);
    }

    public DisabledFacetAbstract(When when, Where where, FacetHolder holder, Semantics semantics) {
        this(DisabledFacetAbstract.type(), when, where, holder, semantics);
    }

    protected DisabledFacetAbstract(Class<? extends Facet> type, When when, Where where, FacetHolder holder, Semantics semantics) {
        super(type, holder, when, where);
        this.semantics = semantics;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        if (this.isInvertedSemantics()) {
            return null;
        }
        if (ic instanceof ActionUsabilityContext && (this.getFacetHolder() instanceof OneToOneAssociationContributee || this.getFacetHolder() instanceof OneToManyAssociationContributee)) {
            return null;
        }
        ObjectAdapter target = ic.getTarget();
        String disabledReason = this.disabledReason(target);
        if (disabledReason != null) {
            return disabledReason;
        }
        if (this.getUnderlyingFacet() != null) {
            DisabledFacet underlyingFacet = (DisabledFacet)this.getUnderlyingFacet();
            return underlyingFacet.disabledReason(target);
        }
        return null;
    }

    @Override
    public boolean isInvertedSemantics() {
        return this.semantics == Semantics.ENABLED;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("semantics", (Object)this.semantics);
        attributeMap.put("inverted", this.isInvertedSemantics());
    }

    public static enum Semantics {
        DISABLED,
        ENABLED;

    }
}

