/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.cssclassfa.annotprop;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.CssClassFa;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.annotprop.CssClassFaFacetOnMemberFromConfiguredRegex;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.annotprop.CssClassFaFacetOnMemberFromProperties;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.annotprop.MixinInterceptor;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class CssClassFaFacetOnMemberFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(CssClassFa.class);
    private static final Pattern FA_ICON_REGEX_PATTERN = Pattern.compile("([^:]+):(.+)");
    private Map<Pattern, String> faIconByPattern;

    public CssClassFaFacetOnMemberFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        CssClassFaFacet cssClassFaFacet = CssClassFaFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (cssClassFaFacet == null) {
            cssClassFaFacet = this.createFromConfiguredRegexIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(cssClassFaFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        CssClassFaFacet cssClassFaFacet = CssClassFaFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(cssClassFaFacet);
    }

    private static CssClassFaFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("cssClassFa");
        return properties != null ? new CssClassFaFacetOnMemberFromProperties(properties, holder) : null;
    }

    private CssClassFaFacet createFromConfiguredRegexIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String value = this.faIconIfAnyFor(MixinInterceptor.intendedNameOf(method));
        CssClassFaPosition position = CssClassFaPosition.LEFT;
        if (value != null) {
            int idxOfSeparator = value.indexOf(58);
            if (idxOfSeparator > -1) {
                value = value.substring(0, idxOfSeparator);
                String rest = value.substring(idxOfSeparator + 1);
                position = CssClassFaPosition.valueOf(rest.toUpperCase());
            }
            return new CssClassFaFacetOnMemberFromConfiguredRegex(value, position, (FacetHolder)processMethodContext.getFacetHolder());
        }
        return null;
    }

    private String faIconIfAnyFor(String name) {
        Map<Pattern, String> faIconByPattern = this.getFaIconByPattern();
        for (Map.Entry<Pattern, String> entry : faIconByPattern.entrySet()) {
            Pattern pattern = entry.getKey();
            String faIcon = entry.getValue();
            if (!pattern.matcher(name).matches()) continue;
            return faIcon;
        }
        return null;
    }

    private Map<Pattern, String> getFaIconByPattern() {
        if (this.faIconByPattern == null) {
            String cssClassFaPatterns = this.getConfiguration().getString("isis.reflector.facet.cssClassFa.patterns");
            this.faIconByPattern = CssClassFaFacetOnMemberFactory.buildFaIconByPattern(cssClassFaPatterns);
        }
        return this.faIconByPattern;
    }

    private static Map<Pattern, String> buildFaIconByPattern(String cssClassFaPatterns) {
        LinkedHashMap faIconByPattern = Maps.newLinkedHashMap();
        if (cssClassFaPatterns != null) {
            StringTokenizer regexToFaIcons = new StringTokenizer(cssClassFaPatterns, ",");
            LinkedHashMap faIconByRegex = Maps.newLinkedHashMap();
            while (regexToFaIcons.hasMoreTokens()) {
                Matcher matcher;
                String regexToFaIcon = regexToFaIcons.nextToken().trim();
                if (Strings.isNullOrEmpty((String)regexToFaIcon) || !(matcher = FA_ICON_REGEX_PATTERN.matcher(regexToFaIcon)).matches()) continue;
                faIconByRegex.put(matcher.group(1), matcher.group(2));
            }
            for (Map.Entry entry : faIconByRegex.entrySet()) {
                String regex = (String)entry.getKey();
                String faIcon = (String)entry.getValue();
                faIconByPattern.put(Pattern.compile(regex), faIcon);
            }
        }
        return faIconByPattern;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        IsisConfiguration configuration = this.getConfiguration();
        this.validator.setConfiguration(configuration);
    }
}

