/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.jaxb;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.jaxb.XmlJavaTypeAdapterFacet;
import org.apache.isis.core.metamodel.facets.jaxb.XmlJavaTypeAdapterFacetDefault;
import org.apache.isis.core.metamodel.facets.jaxb.XmlTransientFacet;
import org.apache.isis.core.metamodel.facets.jaxb.XmlTransientFacetDefault;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.datanucleus.enhancement.Persistable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class XmlJavaTypeAdapterFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public static final String ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_ABSTRACT = "isis.reflector.validator.jaxbViewModelNotAbstract";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_ABSTRACT_DEFAULT = true;
    public static final String ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_INNER_CLASS = "isis.reflector.validator.jaxbViewModelNotInnerClass";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_INNER_CLASS_DEFAULT = true;
    public static final String ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_PUBLIC_NO_ARG_CONSTRUCTOR = "isis.reflector.validator.jaxbViewModelNoArgConstructor";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_PUBLIC_NO_ARG_CONSTRUCTOR_DEFAULT = false;
    public static final String ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_REFERENCE_TYPE_ADAPTER = "isis.reflector.validator.jaxbViewModelReferenceTypeAdapter";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_REFERENCE_TYPE_ADAPTER_DEFAULT = true;
    public static final String ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_DATE_TIME_TYPE_ADAPTER = "isis.reflector.validator.jaxbViewModelDateTimeTypeAdapter";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_DATE_TIME_TYPE_ADAPTER_DEFAULT = true;

    public XmlJavaTypeAdapterFacetFactory() {
        super(FeatureType.OBJECTS_AND_PROPERTIES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        XmlJavaTypeAdapter annotation = Annotations.getAnnotation(cls, XmlJavaTypeAdapter.class);
        if (annotation == null) {
            return;
        }
        Object holder = processClassContext.getFacetHolder();
        XmlJavaTypeAdapterFacetDefault facet = new XmlJavaTypeAdapterFacetDefault((FacetHolder)holder, annotation.value(), this.getSpecificationLoader());
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processXmlJavaTypeAdapter(processMethodContext);
        this.processXmlTransient(processMethodContext);
    }

    private void processXmlJavaTypeAdapter(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        XmlJavaTypeAdapter annotation = Annotations.getAnnotation(method, XmlJavaTypeAdapter.class);
        if (annotation == null) {
            return;
        }
        Object holder = processMethodContext.getFacetHolder();
        XmlJavaTypeAdapterFacetDefault facet = new XmlJavaTypeAdapterFacetDefault((FacetHolder)holder, annotation.value(), this.getSpecificationLoader());
        FacetUtil.addFacet(facet);
    }

    private void processXmlTransient(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        XmlTransient annotation = Annotations.getAnnotation(method, XmlTransient.class);
        if (annotation == null) {
            return;
        }
        Object holder = processMethodContext.getFacetHolder();
        XmlTransientFacetDefault facet = new XmlTransientFacetDefault((FacetHolder)holder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        final List<TypeValidator> typeValidators = this.getTypeValidators(configuration);
        final List<PropertyValidator> propertyValidators = this.getPropertyValidators(configuration);
        MetaModelValidatorVisiting validator = new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                boolean viewModel = objectSpec.isViewModel();
                if (!viewModel) {
                    return;
                }
                ViewModelFacet facet = objectSpec.getFacet(ViewModelFacet.class);
                if (!(facet instanceof RecreatableObjectFacetForXmlRootElementAnnotation)) {
                    return;
                }
                for (TypeValidator typeValidator : typeValidators) {
                    typeValidator.validate(objectSpec, validationFailures);
                }
                List<OneToOneAssociation> properties = objectSpec.getProperties(Contributed.EXCLUDED);
                for (OneToOneAssociation property : properties) {
                    if (!property.containsDoOpFacet(PropertySetterFacet.class)) continue;
                    for (PropertyValidator adapterValidator : propertyValidators) {
                        adapterValidator.validate(objectSpec, property, validationFailures);
                    }
                }
            }
        });
        metaModelValidator.add(validator);
    }

    private List<TypeValidator> getTypeValidators(IsisConfiguration configuration) {
        ArrayList typeValidators = Lists.newArrayList();
        if (configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_ABSTRACT, true)) {
            typeValidators.add(new JaxbViewModelNotAbstractValidator());
        }
        if (configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_NOT_INNER_CLASS, true)) {
            typeValidators.add(new JaxbViewModelNotInnerClassValidator());
        }
        if (configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_PUBLIC_NO_ARG_CONSTRUCTOR, false)) {
            typeValidators.add(new JaxbViewModelPublicNoArgConstructorValidator());
        }
        return typeValidators;
    }

    private List<PropertyValidator> getPropertyValidators(IsisConfiguration configuration) {
        ArrayList propertyValidators = Lists.newArrayList();
        if (configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_REFERENCE_TYPE_ADAPTER, true)) {
            propertyValidators.add(new PropertyValidatorForReferenceTypes());
        }
        if (configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JAXB_VIEW_MODEL_DATE_TIME_TYPE_ADAPTER, true)) {
            propertyValidators.add(new PropertyValidatorForDateTypes(Timestamp.class));
            propertyValidators.add(new PropertyValidatorForDateTypes(DateTime.class));
            propertyValidators.add(new PropertyValidatorForDateTypes(LocalDate.class));
            propertyValidators.add(new PropertyValidatorForDateTypes(LocalDateTime.class));
            propertyValidators.add(new PropertyValidatorForDateTypes(LocalTime.class));
        }
        return propertyValidators;
    }

    private static class JaxbViewModelPublicNoArgConstructorValidator
    extends TypeValidator {
        private JaxbViewModelPublicNoArgConstructorValidator() {
        }

        @Override
        void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
            Constructor<?>[] constructors;
            Class<?> correspondingClass = objectSpec.getCorrespondingClass();
            for (Constructor<?> constructor : constructors = correspondingClass.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    validationFailures.add("JAXB view model '%s' has a no-arg constructor, however it is not public", objectSpec.getFullIdentifier());
                }
                return;
            }
            validationFailures.add("JAXB view model '%s' does not have a public no-arg constructor", objectSpec.getFullIdentifier());
        }
    }

    private static class JaxbViewModelNotInnerClassValidator
    extends TypeValidator {
        private JaxbViewModelNotInnerClassValidator() {
        }

        @Override
        void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
            Class<?> correspondingClass = objectSpec.getCorrespondingClass();
            if (correspondingClass.isAnonymousClass()) {
                validationFailures.add("JAXB view model '%s' is an anonymous class", objectSpec.getFullIdentifier());
            } else if (correspondingClass.isLocalClass()) {
                validationFailures.add("JAXB view model '%s' is a local class", objectSpec.getFullIdentifier());
            } else if (correspondingClass.isMemberClass() && !Modifier.isStatic(correspondingClass.getModifiers())) {
                validationFailures.add("JAXB view model '%s' is an non-static inner class", objectSpec.getFullIdentifier());
            }
        }
    }

    private static class JaxbViewModelNotAbstractValidator
    extends TypeValidator {
        private JaxbViewModelNotAbstractValidator() {
        }

        @Override
        void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
            if (objectSpec.isAbstract()) {
                validationFailures.add("JAXB view model '%s' is abstract", objectSpec.getFullIdentifier());
            }
        }
    }

    private static class PropertyValidatorForDateTypes
    extends PropertyValidator {
        private final Class<?> jodaType;

        private PropertyValidatorForDateTypes(Class<?> jodaType) {
            this.jodaType = jodaType;
        }

        @Override
        void validate(ObjectSpecification objectSpec, OneToOneAssociation property, ValidationFailures validationFailures) {
            ObjectSpecification propertyTypeSpec = property.getSpecification();
            Class<?> propertyType = propertyTypeSpec.getCorrespondingClass();
            if (!this.jodaType.isAssignableFrom(propertyType)) {
                return;
            }
            XmlJavaTypeAdapterFacet xmlJavaTypeAdapterFacet = property.getFacet(XmlJavaTypeAdapterFacet.class);
            if (xmlJavaTypeAdapterFacet != null) {
                return;
            }
            XmlTransientFacet xmlTransientFacet = property.getFacet(XmlTransientFacet.class);
            if (xmlTransientFacet != null) {
                return;
            }
            validationFailures.add("JAXB view model '%s' property '%s' is of type '%s' but is not annotated with @XmlJavaTypeAdapter.  The field/method must be annotated with @XmlJavaTypeAdapter(org.apache.isis.schema.utils.jaxbadapters.XxxAdapter.ForJaxb.class) or equivalent, or be ignored by being annotated with @XmlTransient.", objectSpec.getFullIdentifier(), property.getId(), this.jodaType.getName());
        }
    }

    private static class PropertyValidatorForReferenceTypes
    extends PropertyValidator {
        private PropertyValidatorForReferenceTypes() {
        }

        @Override
        void validate(ObjectSpecification objectSpec, OneToOneAssociation property, ValidationFailures validationFailures) {
            ObjectSpecification propertyTypeSpec = property.getSpecification();
            Class<?> propertyType = propertyTypeSpec.getCorrespondingClass();
            if (!Persistable.class.isAssignableFrom(propertyType)) {
                return;
            }
            XmlJavaTypeAdapterFacet xmlJavaTypeAdapterFacet = propertyTypeSpec.getFacet(XmlJavaTypeAdapterFacet.class);
            if (xmlJavaTypeAdapterFacet != null) {
                return;
            }
            validationFailures.add("JAXB view model '%s' property '%s' is of type '%s' but that type is not annotated with @XmlJavaTypeAdapter.  The type must be annotated with @XmlJavaTypeAdapter(org.apache.isis.schema.utils.jaxbadapters.PersistentEntityAdapter.class) or equivalent.", objectSpec.getFullIdentifier(), property.getId(), propertyType.getName());
        }
    }

    private static abstract class PropertyValidator {
        private PropertyValidator() {
        }

        abstract void validate(ObjectSpecification var1, OneToOneAssociation var2, ValidationFailures var3);
    }

    private static abstract class TypeValidator {
        private TypeValidator() {
        }

        abstract void validate(ObjectSpecification var1, ValidationFailures var2);
    }
}

