/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collparam.semantics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public enum CollectionSemantics {
    LIST{

        @Override
        public Object emptyCollectionOf(Class<?> elementClass) {
            return new ArrayList();
        }
    }
    ,
    ARRAY{

        @Override
        public Object emptyCollectionOf(Class<?> elementClass) {
            return Array.newInstance(elementClass, 0);
        }
    }
    ,
    SORTED_SET{

        @Override
        public Object emptyCollectionOf(Class<?> elementClass) {
            return new TreeSet();
        }
    }
    ,
    SET{

        @Override
        public Object emptyCollectionOf(Class<?> elementClass) {
            return new HashSet();
        }
    }
    ,
    OTHER{

        @Override
        public Object emptyCollectionOf(Class<?> elementClass) {
            return new ArrayList();
        }
    };


    public static CollectionSemantics of(Class<?> accessorReturnType) {
        if (!Collection.class.isAssignableFrom(accessorReturnType)) {
            return ARRAY;
        }
        if (List.class.isAssignableFrom(accessorReturnType)) {
            return LIST;
        }
        if (SortedSet.class.isAssignableFrom(accessorReturnType)) {
            return SORTED_SET;
        }
        if (Set.class.isAssignableFrom(accessorReturnType)) {
            return SET;
        }
        return OTHER;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isSet() {
        return this == SET || this == SORTED_SET;
    }

    public boolean isOther() {
        return this == OTHER;
    }

    public boolean isListOrArray() {
        return this.isList() || this.isArray();
    }

    public abstract Object emptyCollectionOf(Class<?> var1);
}

