/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.modify;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacetAbstract;

public class CollectionRemoveFromFacetViaMethod
extends CollectionRemoveFromFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionRemoveFromFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_COLLECTION_REMOVE;
    }

    @Override
    public void remove(ObjectAdapter owningAdapter, ObjectAdapter elementAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, elementAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("method", this.method);
    }
}

