/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection.modify;

import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.CollectionDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacet;
import org.apache.isis.core.metamodel.interactions.CollectionAddToContext;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public abstract class CollectionDomainEventFacetAbstract
extends SingleClassValueFacetAbstract
implements CollectionDomainEventFacet {
    private final DomainEventHelper domainEventHelper;
    private final TranslationService translationService;
    private final String translationContext;
    private Class<? extends CollectionDomainEvent<?, ?>> eventType;

    public CollectionDomainEventFacetAbstract(Class<? extends CollectionDomainEvent<?, ?>> eventType, FacetHolder holder, ServicesInjector servicesInjector, SpecificationLoader specificationLoader) {
        super(CollectionDomainEventFacet.class, holder, eventType, specificationLoader);
        this.eventType = eventType;
        this.translationService = servicesInjector.lookupService(TranslationService.class);
        this.translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    private Class<?> eventType() {
        return this.value();
    }

    @Override
    public Class<?> value() {
        return this.eventType;
    }

    public Class<? extends CollectionDomainEvent<?, ?>> getEventType() {
        return this.eventType;
    }

    public void setEventType(Class<? extends CollectionDomainEvent<?, ?>> eventType) {
        this.eventType = eventType;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        CollectionDomainEvent<?, ?> event = this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.HIDE, this.eventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), CollectionDomainEvent.Of.ACCESS, null);
        if (event != null && event.isHidden()) {
            return "Hidden by subscriber";
        }
        return null;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        CollectionDomainEvent<?, ?> event = this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.DISABLE, this.eventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), CollectionDomainEvent.Of.ACCESS, null);
        if (event != null && event.isDisabled()) {
            TranslatableString reasonTranslatable = event.getDisabledReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getDisabledReason();
        }
        return null;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> ic) {
        if (!(ic instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder catc = (ProposedHolder)((Object)ic);
        Object proposed = catc.getProposed().getObject();
        CollectionDomainEvent.Of of = ic instanceof CollectionAddToContext ? CollectionDomainEvent.Of.ADD_TO : CollectionDomainEvent.Of.REMOVE_FROM;
        CollectionDomainEvent<?, ?> event = this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.VALIDATE, this.eventType(), null, this.getIdentified(), ic.getTarget(), ic.getMixedIn(), of, proposed);
        if (event != null && event.isInvalid()) {
            TranslatableString reasonTranslatable = event.getInvalidityReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getInvalidityReason();
        }
        return null;
    }
}

