/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionInteraction;
import org.apache.isis.applib.annotation.Disabled;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.NotPersisted;
import org.apache.isis.applib.annotation.PostsCollectionAddedToEvent;
import org.apache.isis.applib.annotation.PostsCollectionRemovedFromEvent;
import org.apache.isis.applib.annotation.TypeOf;
import org.apache.isis.applib.services.eventbus.CollectionDomainEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.disabled.DisabledFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.disabled.DisabledFacetForDisabledAnnotationOnCollection;
import org.apache.isis.core.metamodel.facets.collections.collection.hidden.HiddenFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.hidden.HiddenFacetForHiddenAnnotationOnCollection;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromCollectionInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForPostsCollectionAddedToEventAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetForCollectionInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromCollectionInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForPostsCollectionRemovedFromEventAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.notpersisted.NotPersistedFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.notpersisted.NotPersistedFacetForNotPersistedAnnotationOnCollection;
import org.apache.isis.core.metamodel.facets.collections.collection.typeof.TypeOfFacetOnCollectionFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.typeof.TypeOfFacetOnCollectionFromTypeOfAnnotation;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.CollectionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.CollectionUtils;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;
import org.apache.isis.core.metamodel.util.EventUtil;

public class CollectionAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation postsCollectionAddedToEventValidator = new MetaModelValidatorForDeprecatedAnnotation(PostsCollectionAddedToEvent.class);
    private final MetaModelValidatorForDeprecatedAnnotation postsCollectionRemovedFromEventValidator = new MetaModelValidatorForDeprecatedAnnotation(PostsCollectionRemovedFromEvent.class);
    private final MetaModelValidatorForDeprecatedAnnotation collectionInteractionValidator = new MetaModelValidatorForDeprecatedAnnotation(CollectionInteraction.class);
    private final MetaModelValidatorForDeprecatedAnnotation hiddenValidator = new MetaModelValidatorForDeprecatedAnnotation(Hidden.class);
    private final MetaModelValidatorForDeprecatedAnnotation disabledValidator = new MetaModelValidatorForDeprecatedAnnotation(Disabled.class);
    private final MetaModelValidatorForDeprecatedAnnotation notPersistedValidator = new MetaModelValidatorForDeprecatedAnnotation(NotPersisted.class);
    private final MetaModelValidatorForDeprecatedAnnotation typeOfValidator = new MetaModelValidatorForDeprecatedAnnotation(TypeOf.class);

    public CollectionAnnotationFacetFactory() {
        super(FeatureType.COLLECTIONS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processModify(processMethodContext);
        this.processHidden(processMethodContext);
        this.processEditing(processMethodContext);
        this.processNotPersisted(processMethodContext);
        this.processTypeOf(processMethodContext);
    }

    void processModify(FacetFactory.ProcessMethodContext processMethodContext) {
        CollectionRemoveFromFacet collectionRemoveFromFacet;
        CollectionAddToFacet collectionAddToFacet;
        CollectionDomainEventFacetAbstract collectionDomainEventFacet;
        Class<? extends CollectionDomainEvent<?, ?>> collectionDomainEventType;
        Method method = processMethodContext.getMethod();
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
        Facet holder = processMethodContext.getFacetHolder();
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return;
        }
        PostsCollectionAddedToEvent postsCollectionAddedToEvent = Annotations.getAnnotation(method, PostsCollectionAddedToEvent.class);
        PostsCollectionRemovedFromEvent postsCollectionRemovedFromEvent = Annotations.getAnnotation(method, PostsCollectionRemovedFromEvent.class);
        CollectionInteraction collectionInteraction = Annotations.getAnnotation(method, CollectionInteraction.class);
        Collection collection = Annotations.getAnnotation(method, Collection.class);
        if (collectionInteraction != null) {
            collectionDomainEventType = CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, collectionInteraction.value());
            collectionDomainEventFacet = this.collectionInteractionValidator.flagIfPresent(new CollectionDomainEventFacetForCollectionInteractionAnnotation(collectionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)((Object)holder)), processMethodContext);
        } else if (collection != null) {
            collectionDomainEventType = CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, collection.domainEvent());
            collectionDomainEventFacet = new CollectionDomainEventFacetForCollectionAnnotation(collectionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)((Object)holder));
        } else {
            collectionDomainEventType = CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, CollectionDomainEvent.Default.class);
            collectionDomainEventFacet = new CollectionDomainEventFacetDefault(collectionDomainEventType, this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)((Object)holder));
        }
        if (!CollectionDomainEvent.Noop.class.isAssignableFrom(collectionDomainEventFacet.getEventType())) {
            FacetUtil.addFacet(collectionDomainEventFacet);
        }
        if (EventUtil.eventTypeIsPostable(collectionDomainEventFacet.getEventType(), CollectionDomainEvent.Noop.class, CollectionDomainEvent.Default.class, "isis.reflector.facet.collectionAnnotation.domainEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(collectionDomainEventFacet);
        }
        if ((collectionAddToFacet = holder.getFacet(CollectionAddToFacet.class)) != null) {
            CollectionAddToFacetForDomainEventFromAbstract replacementFacet = postsCollectionAddedToEvent != null ? new CollectionAddToFacetForPostsCollectionAddedToEventAnnotation(postsCollectionAddedToEvent.value(), getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector) : (collectionInteraction != null ? new CollectionAddToFacetForDomainEventFromCollectionInteractionAnnotation(collectionDomainEventType, getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector) : (collection != null ? new CollectionAddToFacetForDomainEventFromCollectionAnnotation(collectionDomainEventType, getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector) : new CollectionAddToFacetForDomainEventFromDefault(collectionDomainEventType, getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector)));
            FacetUtil.addFacet(replacementFacet);
        }
        if ((collectionRemoveFromFacet = holder.getFacet(CollectionRemoveFromFacet.class)) != null) {
            CollectionRemoveFromFacetForDomainEventFromAbstract replacementFacet = postsCollectionRemovedFromEvent != null ? new CollectionRemoveFromFacetForPostsCollectionRemovedFromEventAnnotation(postsCollectionRemovedFromEvent.value(), getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder)) : (collectionInteraction != null ? new CollectionRemoveFromFacetForDomainEventFromCollectionInteractionAnnotation(collectionDomainEventType, getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder)) : (collection != null ? new CollectionRemoveFromFacetForDomainEventFromCollectionAnnotation(collectionDomainEventType, getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder)) : new CollectionRemoveFromFacetForDomainEventFromDefault(collectionDomainEventType, getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder))));
            FacetUtil.addFacet(replacementFacet);
        }
    }

    public static Class<? extends CollectionDomainEvent<?, ?>> defaultFromDomainObjectIfRequired(ObjectSpecification typeSpec, Class<? extends CollectionDomainEvent<?, ?>> collectionDomainEventType) {
        CollectionDomainEventDefaultFacetForDomainObjectAnnotation typeFromDomainObject;
        if (collectionDomainEventType == CollectionDomainEvent.Default.class && (typeFromDomainObject = typeSpec.getFacet(CollectionDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null) {
            return typeFromDomainObject.getEventType();
        }
        return collectionDomainEventType;
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Hidden hiddenAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Hidden.class);
        HiddenFacet facet = this.hiddenValidator.flagIfPresent(HiddenFacetForHiddenAnnotationOnCollection.create(hiddenAnnotation, holder), processMethodContext);
        Collection collection = Annotations.getAnnotation(method, Collection.class);
        if (facet == null) {
            facet = HiddenFacetForCollectionAnnotation.create(collection, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Disabled annotation = Annotations.getAnnotation(method, Disabled.class);
        DisabledFacet facet = this.disabledValidator.flagIfPresent(DisabledFacetForDisabledAnnotationOnCollection.create(annotation, holder), processMethodContext);
        Collection collection = Annotations.getAnnotation(method, Collection.class);
        if (facet == null) {
            facet = DisabledFacetForCollectionAnnotation.create(collection, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processNotPersisted(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        NotPersisted annotation = Annotations.getAnnotation(method, NotPersisted.class);
        NotPersistedFacet facet1 = NotPersistedFacetForNotPersistedAnnotationOnCollection.create(annotation, holder);
        FacetUtil.addFacet(this.notPersistedValidator.flagIfPresent(facet1, processMethodContext));
        NotPersistedFacet facet = facet1;
        Collection collection = Annotations.getAnnotation(method, Collection.class);
        if (facet == null) {
            facet = NotPersistedFacetForCollectionAnnotation.create(collection, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processTypeOf(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType;
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Method method = processMethodContext.getMethod();
        Class<?> methodReturnType = method.getReturnType();
        if (!CollectionUtils.isCollectionType(methodReturnType) && !CollectionUtils.isArrayType(methodReturnType)) {
            return;
        }
        TypeOf annotation = Annotations.getAnnotation(method, TypeOf.class);
        TypeOfFacet facet = this.typeOfValidator.flagIfPresent(TypeOfFacetOnCollectionFromTypeOfAnnotation.create(annotation, facetHolder, this.getSpecificationLoader()), processMethodContext);
        Collection collection = Annotations.getAnnotation(method, Collection.class);
        if (facet == null) {
            facet = TypeOfFacetOnCollectionFromCollectionAnnotation.create(collection, facetHolder, this.getSpecificationLoader());
        }
        if (facet == null && (returnType = method.getReturnType()).isArray()) {
            Class<?> componentType = returnType.getComponentType();
            facet = new TypeOfFacetInferredFromArray(componentType, (FacetHolder)facetHolder, this.getSpecificationLoader());
        }
        if (facet == null) {
            facet = this.inferFromGenericReturnType(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    private TypeOfFacet inferFromGenericReturnType(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Method method = processMethodContext.getMethod();
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return null;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            return new TypeOfFacetInferredFromGenerics(actualType, (FacetHolder)facetHolder, this.getSpecificationLoader());
        }
        if (actualTypeArgument instanceof TypeVariable) {
            return null;
        }
        return null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.postsCollectionAddedToEventValidator);
        metaModelValidator.add(this.postsCollectionRemovedFromEventValidator);
        metaModelValidator.add(this.collectionInteractionValidator);
        metaModelValidator.add(this.notPersistedValidator);
        metaModelValidator.add(this.typeOfValidator);
        metaModelValidator.add(this.hiddenValidator);
        metaModelValidator.add(this.disabledValidator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        IsisConfiguration configuration = this.getConfiguration();
        this.postsCollectionAddedToEventValidator.setConfiguration(configuration);
        this.postsCollectionRemovedFromEventValidator.setConfiguration(configuration);
        this.collectionInteractionValidator.setConfiguration(configuration);
        this.typeOfValidator.setConfiguration(configuration);
        this.notPersistedValidator.setConfiguration(configuration);
        this.hiddenValidator.setConfiguration(configuration);
        this.disabledValidator.setConfiguration(configuration);
    }
}

