/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.accessor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.collections.accessor.CollectionAccessorFacetViaAccessor;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemanticsFacetDefault;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class CollectionAccessorFacetViaAccessorFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"get"};
    PersistenceSessionServiceInternal adapterManager;

    public CollectionAccessorFacetViaAccessorFactory() {
        super(FeatureType.COLLECTIONS_ONLY, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachAccessorFacetForAccessorMethod(processMethodContext);
    }

    private void attachAccessorFacetForAccessorMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        processMethodContext.removeMethod(accessorMethod);
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
        Object holder = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new CollectionAccessorFacetViaAccessor(typeSpec, accessorMethod, (FacetHolder)holder, this.getDeploymentCategory(), this.getConfiguration(), this.getSpecificationLoader(), this.getAuthenticationSessionProvider(), this.adapterManager));
        FacetUtil.addFacet(CollectionSemanticsFacetDefault.forCollection(accessorMethod, holder));
    }

    @Override
    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        return method.getName().startsWith("get");
    }

    @Override
    public boolean isCollectionAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    @Override
    public boolean isPropertyAccessor(Method method) {
        return false;
    }

    @Override
    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        List<Method> list = methodRemover.removeMethods(MethodScope.OBJECT, "get", Collection.class, false, 0);
        methodListToAppendTo.addAll(list);
    }

    @Override
    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

