/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.all.i18n;

import java.util.Map;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;

public class DescribedAsFacetTranslated
extends FacetAbstract
implements DescribedAsFacet {
    private final String context;
    private final String originalText;
    private final TranslationService translationService;

    public DescribedAsFacetTranslated(String context, String originalText, TranslationService translationService, IdentifiedHolder holder) {
        super(DescribedAsFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.context = context;
        this.originalText = originalText;
        this.translationService = translationService;
        if (translationService.getMode().isWrite()) {
            this.translateText();
        }
    }

    @Override
    public String value() {
        return this.translateText();
    }

    private String translateText() {
        return this.translationService.translate(this.context, this.originalText);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("context", this.context);
        attributeMap.put("originalText", this.originalText);
    }
}

