/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.layout;

import java.util.Map;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleConfiguration;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAsConfigured;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetFallBackToInline;

public class PromptStyleFacetForActionLayoutAnnotation
extends PromptStyleFacetAbstract {
    private final PromptStyle promptStyle;

    public PromptStyleFacetForActionLayoutAnnotation(PromptStyle promptStyle, FacetHolder holder) {
        super(holder);
        this.promptStyle = promptStyle;
    }

    public static PromptStyleFacet create(ActionLayout actionLayout, IsisConfiguration configuration, FacetHolder holder) {
        PromptStyle promptStyle;
        PromptStyle promptStyle2 = promptStyle = actionLayout != null ? actionLayout.promptStyle() : null;
        if (promptStyle == null) {
            if (holder.containsDoOpNotDerivedFacet(PromptStyleFacet.class)) {
                return null;
            }
            return new PromptStyleFacetFallBackToInline(holder);
        }
        switch (promptStyle) {
            case DIALOG: 
            case INLINE: 
            case INLINE_AS_IF_EDIT: {
                return new PromptStyleFacetForActionLayoutAnnotation(promptStyle, holder);
            }
            case AS_CONFIGURED: {
                if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
                    return null;
                }
                promptStyle = PromptStyleConfiguration.parse(configuration);
                return new PromptStyleFacetAsConfigured(promptStyle, holder);
            }
        }
        if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
            return null;
        }
        promptStyle = PromptStyleConfiguration.parse(configuration);
        return new PromptStyleFacetAsConfigured(promptStyle, holder);
    }

    @Override
    public PromptStyle value() {
        return this.promptStyle;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("promptStyle", this.promptStyle);
    }
}

