/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.interaction;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.interaction.PrototypeFacetViaExplorationPrefixNamingConvention;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class ActionNamedExplorationFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private static final String EXPLORATION_PREFIX = "Exploration";
    private final MetaModelValidatorForDeprecatedMethodPrefix explorationValidator = new MetaModelValidatorForDeprecatedMethodPrefix("Exploration");
    private static final String[] PREFIXES = new String[]{"Exploration"};

    public ActionNamedExplorationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachExplorationFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachNamedFacetInferredFromMethodName(processMethodContext);
    }

    private void attachExplorationFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        if (!capitalizedName.startsWith(EXPLORATION_PREFIX)) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        PrototypeFacetViaExplorationPrefixNamingConvention facet = new PrototypeFacetViaExplorationPrefixNamingConvention((FacetHolder)facetedMethod, this.getDeploymentCategory());
        FacetUtil.addFacet(this.explorationValidator.flagIfPresent(facet, processMethodContext));
    }

    private void attachNamedFacetInferredFromMethodName(FacetFactory.ProcessMethodContext processMethodContext) {
        String capitalizedName;
        Method method = processMethodContext.getMethod();
        String name = capitalizedName = StringExtensions.asCapitalizedName(method.getName());
        name = StringExtensions.removePrefix(name, EXPLORATION_PREFIX);
        name = StringExtensions.asNaturalName2(name);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new NamedFacetInferred(name, (FacetHolder)facetedMethod));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.explorationValidator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.explorationValidator.setConfiguration(configuration);
    }
}

