/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.homepage.annotation;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.HomePage;
import org.apache.isis.applib.services.homepage.AbstractHomePageDashboardService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actions.homepage.HomePageFacet;
import org.apache.isis.core.metamodel.facets.actions.homepage.annotation.HomePageFacetAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class HomePageFacetAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public HomePageFacetAnnotationFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HomePage annotation = Annotations.getAnnotation(processMethodContext.getMethod(), HomePage.class);
        if (annotation == null) {
            return;
        }
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new HomePageFacetAnnotation(facetHolder));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.SummarizingVisitor(){
            private final List<String> annotated = Lists.newArrayList();

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                List<ObjectAction> objectActions = objectSpec.getObjectActions(Contributed.EXCLUDED);
                if (objectSpec.getCorrespondingClass() == AbstractHomePageDashboardService.class) {
                    return true;
                }
                for (ObjectAction objectAction : objectActions) {
                    if (!objectAction.containsFacet(HomePageFacet.class)) continue;
                    String fullIdentifier = objectAction.getIdentifier().toClassAndNameIdentityString();
                    this.annotated.add(fullIdentifier);
                }
                return true;
            }

            @Override
            public void summarize(ValidationFailures validationFailures) {
                if (this.annotated.size() > 1) {
                    for (String actionId : this.annotated) {
                        ArrayList others = Lists.newArrayList(this.annotated);
                        others.remove(actionId);
                        String nonServiceNamesStr = Joiner.on((String)", ").join((Iterable)others);
                        validationFailures.add("%s: other actions also specified as home page: %s ", actionId, nonServiceNamesStr);
                    }
                }
            }
        };
    }
}

