/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.exploration.annotation;

import org.apache.isis.applib.annotation.Exploration;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.exploration.annotation.PrototypeFacetForExplorationAnnotation;
import org.apache.isis.core.metamodel.facets.actions.prototype.PrototypeFacet;
import org.apache.isis.core.metamodel.progmodel.DeprecatedMarker;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class PrototypeFacetForExplorationAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
DeprecatedMarker {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(Exploration.class);

    public PrototypeFacetForExplorationAnnotationFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Exploration annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Exploration.class);
        PrototypeFacet facet = this.create(annotation, (FacetHolder)processMethodContext.getFacetHolder());
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private PrototypeFacet create(Exploration annotation, FacetHolder holder) {
        return annotation == null ? null : new PrototypeFacetForExplorationAnnotation(holder, this.getDeploymentCategory());
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.validator.setConfiguration(servicesInjector.getConfigurationServiceInternal());
    }
}

