/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.defaults.method;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.defaults.method.ActionDefaultsFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class ActionDefaultsFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"default"};

    public ActionDefaultsFacetViaMethodFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        ActionDefaultsFacetViaMethodFactory.attachActionDefaultsFacetIfParameterDefaultsMethodIsFound(processMethodContext);
    }

    private static void attachActionDefaultsFacetIfParameterDefaultsMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method defaultsMethod = ActionDefaultsFacetViaMethodFactory.findDefaultsMethodReturning(processMethodContext, Object[].class);
        if (defaultsMethod == null) {
            defaultsMethod = ActionDefaultsFacetViaMethodFactory.findDefaultsMethodReturning(processMethodContext, List.class);
        }
        if (defaultsMethod == null) {
            return;
        }
        processMethodContext.removeMethod(defaultsMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        ActionDefaultsFacetViaMethod facet = new ActionDefaultsFacetViaMethod(defaultsMethod, (FacetHolder)facetedMethod);
        FacetUtil.addFacet(facet);
    }

    private static Method findDefaultsMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, Class<?> returnType) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        String name = "default" + capitalizedName;
        Class<?> cls = processMethodContext.getCls();
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, returnType, new Class[0]);
    }
}

