/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.publishing;

import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.PublishingPayloadFactoryForAction;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishActionsConfiguration;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetForActionAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;

public class PublishedActionFacetForActionAnnotation
extends PublishedActionFacetAbstract {
    public static PublishedActionFacet create(Action action, IsisConfiguration configuration, FacetHolder holder) {
        Publishing publishing = action != null ? action.publishing() : Publishing.AS_CONFIGURED;
        switch (publishing) {
            case AS_CONFIGURED: {
                PublishActionsConfiguration setting = PublishActionsConfiguration.parse(configuration);
                switch (setting) {
                    case NONE: {
                        return null;
                    }
                    case IGNORE_SAFE: {
                        ActionSemanticsFacet actionSemanticsFacet = holder.getFacet(ActionSemanticsFacet.class);
                        if (actionSemanticsFacet == null) {
                            throw new IllegalStateException("Require ActionSemanticsFacet in order to process");
                        }
                        if (!((ActionSemantics.Of)actionSemanticsFacet.value()).isSafeInNature()) break;
                        return null;
                    }
                }
                PublishingPayloadFactoryForAction publishingPayloadFactory = PublishedActionFacetForActionAnnotation.newPayloadFactory(action);
                return action != null ? new PublishedActionFacetForActionAnnotationAsConfigured(publishingPayloadFactory, holder) : new PublishedActionFacetFromConfiguration(publishingPayloadFactory, holder);
            }
            case DISABLED: {
                return null;
            }
            case ENABLED: {
                return new PublishedActionFacetForActionAnnotation(PublishedActionFacetForActionAnnotation.newPayloadFactory(action), holder);
            }
        }
        return null;
    }

    private static PublishingPayloadFactoryForAction newPayloadFactory(Action action) {
        if (action == null) {
            return null;
        }
        Class payloadFactoryClass = action.publishingPayloadFactory();
        if (payloadFactoryClass == null) {
            return null;
        }
        try {
            return (PublishingPayloadFactoryForAction)payloadFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public PublishedActionFacetForActionAnnotation(PublishingPayloadFactoryForAction publishingPayloadFactory, FacetHolder holder) {
        super(publishingPayloadFactory, holder);
    }
}

