/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.command;

import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.CommandPersistence;
import org.apache.isis.applib.annotation.CommandReification;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandActionsConfiguration;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetForActionAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class CommandFacetForActionAnnotation
extends CommandFacetAbstract {
    public static CommandFacet create(Action action, IsisConfiguration configuration, ServicesInjector servicesInjector, FacetHolder holder) {
        CommandReification commandReification = action != null ? action.command() : CommandReification.AS_CONFIGURED;
        CommandPersistence commandPersistence = action != null ? action.commandPersistence() : CommandPersistence.PERSISTED;
        CommandExecuteIn commandExecuteIn = action != null ? action.commandExecuteIn() : CommandExecuteIn.FOREGROUND;
        Class processorClass = action != null ? action.commandDtoProcessor() : null;
        CommandDtoProcessor processor = CommandFacetForActionAnnotation.newProcessorElseNull(processorClass);
        if (processor != null) {
            commandReification = CommandReification.ENABLED;
            commandPersistence = CommandPersistence.PERSISTED;
        }
        Command.Persistence persistence = CommandPersistence.from((CommandPersistence)commandPersistence);
        Command.ExecuteIn executeIn = CommandExecuteIn.from((CommandExecuteIn)commandExecuteIn);
        switch (commandReification) {
            case AS_CONFIGURED: {
                CommandActionsConfiguration setting = CommandActionsConfiguration.parse(configuration);
                switch (setting) {
                    case NONE: {
                        return null;
                    }
                    case IGNORE_SAFE: {
                        ActionSemanticsFacet actionSemanticsFacet = holder.getFacet(ActionSemanticsFacet.class);
                        if (actionSemanticsFacet == null) {
                            throw new IllegalStateException("Require ActionSemanticsFacet in order to process");
                        }
                        if (!((ActionSemantics.Of)actionSemanticsFacet.value()).isSafeInNature()) break;
                        return null;
                    }
                }
                return action != null ? new CommandFacetForActionAnnotationAsConfigured(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, holder, servicesInjector) : CommandFacetFromConfiguration.create(holder, servicesInjector);
            }
            case DISABLED: {
                return null;
            }
            case ENABLED: {
                return new CommandFacetForActionAnnotation(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, processor, holder, servicesInjector);
            }
        }
        return null;
    }

    CommandFacetForActionAnnotation(Command.Persistence persistence, Command.ExecuteIn executeIn, CommandFacetAbstract.Enablement enablement, CommandDtoProcessor processor, FacetHolder holder, ServicesInjector servicesInjector) {
        super(persistence, executeIn, enablement, processor, holder, servicesInjector);
    }
}

