/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.util.Map;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleStringValueFacet;

public abstract class SingleStringValueFacetAbstract
extends FacetAbstract
implements SingleStringValueFacet {
    private final String value;

    public SingleStringValueFacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, String value) {
        this(facetType, holder, value, FacetAbstract.Derivation.NOT_DERIVED);
    }

    public SingleStringValueFacetAbstract(Class<? extends Facet> type, FacetHolder holder, String value, FacetAbstract.Derivation derivation) {
        super(type, holder, derivation);
        this.value = value;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    protected String toStringValues() {
        if (this.value == null) {
            return "null";
        }
        return "\"" + this.value + "\"";
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("value", this.value);
    }
}

