/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.Command2;
import org.apache.isis.applib.services.command.Command3;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.AbstractInteractionEvent;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.eventbus.ActionInteractionEvent;
import org.apache.isis.applib.services.eventbus.CollectionDomainEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;

public class DomainEventHelper {
    private final ServicesInjector servicesInjector;

    public DomainEventHelper(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    public ActionDomainEvent<?> postEventForAction(AbstractDomainEvent.Phase phase, Class eventType, ActionDomainEvent<?> existingEvent, ObjectAction objectAction, IdentifiedHolder identified, ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, ObjectAdapter[] argumentAdapters, Command command, ObjectAdapter resultAdapter) {
        try {
            Object event;
            if (existingEvent != null && phase.isExecuted()) {
                event = existingEvent;
            } else {
                Object source = ObjectAdapter.Util.unwrap(targetAdapter);
                Object[] arguments = ObjectAdapter.Util.unwrap(argumentAdapters);
                Identifier identifier = identified.getIdentifier();
                event = DomainEventHelper.newActionDomainEvent(eventType, identifier, source, arguments);
                if (mixedInAdapter != null) {
                    event.setMixedIn(mixedInAdapter.getObject());
                }
                if (objectAction != null) {
                    event.setActionSemantics(objectAction.getSemantics());
                    List<ObjectActionParameter> parameters = objectAction.getParameters();
                    event.setParameterNames(DomainEventHelper.immutableList(Iterables.transform(parameters, ObjectActionParameter.Functions.GET_NAME)));
                    event.setParameterTypes(DomainEventHelper.immutableList(Iterables.transform(parameters, ObjectActionParameter.Functions.GET_TYPE)));
                }
            }
            event.setEventPhase(phase);
            event.setPhase(AbstractInteractionEvent.Phase.from((AbstractDomainEvent.Phase)phase));
            if (phase.isExecuted()) {
                event.setReturnValue(ObjectAdapter.Util.unwrap(resultAdapter));
            }
            if (command != null) {
                event.setCommand(command);
            }
            if (command != null && phase.isExecuting()) {
                if (command instanceof Command3) {
                    Command3 command3 = (Command3)command;
                    command3.pushActionDomainEvent(event);
                } else if (command instanceof Command2 && event instanceof ActionInteractionEvent) {
                    Command3 command2 = (Command3)command;
                    ActionInteractionEvent aie = (ActionInteractionEvent)event;
                    command2.pushActionInteractionEvent(aie);
                }
            }
            this.getEventBusService().post(event);
            return event;
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    private static <T> List<T> immutableList(Iterable<T> iterable) {
        return Collections.unmodifiableList(Lists.newArrayList(iterable));
    }

    static <S> ActionDomainEvent<S> newActionDomainEvent(Class<? extends ActionDomainEvent<S>> type, Identifier identifier, S source, Object ... arguments) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?>[] parameterTypes;
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 0) continue;
            Object event = constructor.newInstance(new Object[0]);
            ActionDomainEvent ade = (ActionDomainEvent)event;
            ade.setSource(source);
            ade.setIdentifier(identifier);
            ade.setArguments(DomainEventHelper.asList(arguments));
            return ade;
        }
        for (Constructor<?> constructor : constructors) {
            parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 3 || !parameterTypes[0].isAssignableFrom(source.getClass()) || !parameterTypes[1].isAssignableFrom(Identifier.class) || !parameterTypes[2].isAssignableFrom(Object[].class)) continue;
            Object event = constructor.newInstance(source, identifier, arguments);
            return (ActionDomainEvent)event;
        }
        throw new NoSuchMethodException(type.getName() + ".<init>(? super " + source.getClass().getName() + ", " + Identifier.class.getName() + ", [Ljava.lang.Object;)");
    }

    private static List<Object> asList(Object[] arguments) {
        return arguments != null ? Arrays.asList(arguments) : Collections.emptyList();
    }

    public PropertyDomainEvent<?, ?> postEventForProperty(AbstractDomainEvent.Phase phase, Class eventType, PropertyDomainEvent<?, ?> existingEvent, IdentifiedHolder identified, ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, Object oldValue, Object newValue) {
        try {
            Object event;
            Object source = ObjectAdapter.Util.unwrap(targetAdapter);
            Identifier identifier = identified.getIdentifier();
            if (existingEvent != null && phase.isExecuted()) {
                event = existingEvent;
            } else {
                event = DomainEventHelper.newPropertyDomainEvent(eventType, identifier, source, oldValue, newValue);
                if (mixedInAdapter != null) {
                    event.setMixedIn(mixedInAdapter.getObject());
                }
            }
            event.setEventPhase(phase);
            event.setPhase(AbstractInteractionEvent.Phase.from((AbstractDomainEvent.Phase)phase));
            DomainEventHelper.setEventNewValue(event, newValue);
            this.getEventBusService().post(event);
            return event;
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    private static <S, T> void setEventNewValue(PropertyDomainEvent<S, T> event, Object newValue) {
        event.setNewValue(newValue);
    }

    static <S, T> PropertyDomainEvent<S, T> newPropertyDomainEvent(Class<? extends PropertyDomainEvent<S, T>> type, Identifier identifier, S source, T oldValue, T newValue) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] parameterTypes;
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 0) continue;
            Object event = constructor.newInstance(new Object[0]);
            PropertyDomainEvent pde = (PropertyDomainEvent)event;
            pde.setSource(source);
            pde.setIdentifier(identifier);
            pde.setOldValue(oldValue);
            pde.setNewValue(newValue);
            return pde;
        }
        for (Constructor<?> constructor : constructors) {
            parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 4 || !parameterTypes[0].isAssignableFrom(source.getClass()) || !parameterTypes[1].isAssignableFrom(Identifier.class) || oldValue != null && !parameterTypes[2].isAssignableFrom(oldValue.getClass()) || newValue != null && !parameterTypes[3].isAssignableFrom(newValue.getClass())) continue;
            Object event = constructor.newInstance(source, identifier, oldValue, newValue);
            return (PropertyDomainEvent)event;
        }
        throw new NoSuchMethodException(type.getName() + ".<init>(? super " + source.getClass().getName() + ", " + Identifier.class.getName() + ", java.lang.Object, java.lang.Object)");
    }

    public CollectionDomainEvent<?, ?> postEventForCollection(AbstractDomainEvent.Phase phase, Class eventType, CollectionDomainEvent<?, ?> existingEvent, IdentifiedHolder identified, ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, CollectionDomainEvent.Of of, Object reference) {
        try {
            Object event;
            if (existingEvent != null && phase.isExecuted()) {
                event = existingEvent;
            } else {
                Object source = ObjectAdapter.Util.unwrap(targetAdapter);
                Identifier identifier = identified.getIdentifier();
                event = this.newCollectionDomainEvent(eventType, phase, identifier, source, of, reference);
                if (mixedInAdapter != null) {
                    event.setMixedIn(mixedInAdapter.getObject());
                }
            }
            event.setEventPhase(phase);
            event.setPhase(AbstractInteractionEvent.Phase.from((AbstractDomainEvent.Phase)phase));
            this.getEventBusService().post(event);
            return event;
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    <S, T> CollectionDomainEvent<S, T> newCollectionDomainEvent(Class<? extends CollectionDomainEvent<S, T>> type, AbstractDomainEvent.Phase phase, Identifier identifier, S source, CollectionDomainEvent.Of of, T value) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        block4: {
            Class<?>[] parameterTypes;
            Constructor<?>[] constructors;
            block5: {
                for (Constructor<?> constructor : constructors = type.getConstructors()) {
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 0) continue;
                    Object event = constructor.newInstance(new Object[0]);
                    CollectionDomainEvent cde = (CollectionDomainEvent)event;
                    cde.setSource(source);
                    cde.setIdentifier(identifier);
                    cde.setOf(of);
                    cde.setValue(value);
                    return cde;
                }
                for (Constructor<?> constructor : constructors) {
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 4 || !parameterTypes[0].isAssignableFrom(source.getClass()) || !parameterTypes[1].isAssignableFrom(Identifier.class) || !parameterTypes[2].isAssignableFrom(CollectionDomainEvent.Of.class) || value != null && !parameterTypes[3].isAssignableFrom(value.getClass())) continue;
                    Object event = constructor.newInstance(source, identifier, of, value);
                    return (CollectionDomainEvent)event;
                }
                if (phase != AbstractDomainEvent.Phase.EXECUTED) break block4;
                if (of != CollectionDomainEvent.Of.ADD_TO) break block5;
                for (Constructor<?> constructor : constructors) {
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 3 || !parameterTypes[0].isAssignableFrom(source.getClass()) || !parameterTypes[1].isAssignableFrom(Identifier.class) || value != null && !parameterTypes[2].isAssignableFrom(value.getClass())) continue;
                    Object event = constructor.newInstance(source, identifier, value);
                    return (CollectionDomainEvent)event;
                }
                break block4;
            }
            if (of != CollectionDomainEvent.Of.REMOVE_FROM) break block4;
            for (Constructor<?> constructor : constructors) {
                parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 3 || !parameterTypes[0].isAssignableFrom(source.getClass()) || !parameterTypes[1].isAssignableFrom(Identifier.class) || value != null && !parameterTypes[2].isAssignableFrom(value.getClass())) continue;
                Object event = constructor.newInstance(source, identifier, value);
                return (CollectionDomainEvent)event;
            }
        }
        throw new NoSuchMethodException(type.getName() + ".<init>(? super " + source.getClass().getName() + ", " + Identifier.class.getName() + ", java.lang.Object)");
    }

    private EventBusService getEventBusService() {
        return this.servicesInjector.lookupService(EventBusService.class);
    }
}

