/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.jdo.annotations.Column;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public final class Annotations {
    private static List<Class<?>> fieldAnnotationClasses = Collections.unmodifiableList(Arrays.asList(Property.class, PropertyLayout.class, Collection.class, CollectionLayout.class, Programmatic.class, MemberOrder.class, Nullable.class, Title.class, XmlJavaTypeAdapter.class, Column.class));

    private Annotations() {
    }

    public static boolean isString(Class<?> cls) {
        return cls.equals(String.class);
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<?> cls, Class<T> annotationClass) {
        Annotation[] declaredAnnotations = cls.getDeclaredAnnotations();
        if (declaredAnnotations == null) {
            return null;
        }
        for (Annotation annotation : declaredAnnotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = Annotations.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException annotationFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = Annotations.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        Class<?> superclass;
        if (method == null) {
            return null;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        String methodName = method.getName();
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (Annotations.shouldSearchForField(annotationClass)) {
            List<String> fieldNameCandidates = Annotations.fieldNameCandidatesFor(methodName);
            for (String fieldNameCandidate : fieldNameCandidates) {
                try {
                    Field field = methodDeclaringClass.getDeclaredField(fieldNameCandidate);
                    T fieldAnnotation = field.getAnnotation(annotationClass);
                    if (fieldAnnotation == null) continue;
                    return fieldAnnotation;
                }
                catch (NoSuchFieldException field) {
                }
            }
        }
        if ((superclass = methodDeclaringClass.getSuperclass()) != null) {
            try {
                Method parentClassMethod = superclass.getMethod(methodName, method.getParameterTypes());
                return Annotations.getAnnotation(parentClassMethod, annotationClass);
            }
            catch (NoSuchMethodException | SecurityException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(methodName, method.getParameterTypes());
                return Annotations.getAnnotation(ifaceMethod, annotationClass);
            }
            catch (NoSuchMethodException | SecurityException exception) {
            }
        }
        return null;
    }

    public static <T extends Annotation> List<Evaluator<T>> getEvaluators(Class<?> cls, Class<T> annotationClass) {
        ArrayList evaluators = Lists.newArrayList();
        Annotations.appendEvaluators(cls, annotationClass, evaluators);
        return evaluators;
    }

    private static <T extends Annotation> void appendEvaluators(Class<?> cls, Class<T> annotationClass, List<Evaluator<T>> evaluators) {
        Class<?>[] interfaces;
        T annotation;
        for (Method method : cls.getDeclaredMethods()) {
            if (!MethodScope.OBJECT.matchesScopeOf(method) || method.getParameterTypes().length != 0 || (annotation = method.getAnnotation(annotationClass)) == null) continue;
            evaluators.add(new MethodEvaluator<T>(method, annotation));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            annotation = ((Field)accessibleObject).getAnnotation(annotationClass);
            if (annotation == null) continue;
            evaluators.add(new FieldEvaluator<T>((Field)accessibleObject, annotation));
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            Annotations.appendEvaluators(superclass, annotationClass, evaluators);
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            Annotations.appendEvaluators(iface, annotationClass, evaluators);
        }
    }

    private static boolean shouldSearchForField(Class<?> annotationClass) {
        return fieldAnnotationClasses.contains(annotationClass);
    }

    static List<String> fieldNameCandidatesFor(String methodName) {
        if (methodName == null) {
            return Collections.emptyList();
        }
        int beginIndex = methodName.startsWith("get") ? 3 : (methodName.startsWith("is") ? 2 : -1);
        if (beginIndex == -1) {
            return Collections.emptyList();
        }
        String suffix = methodName.substring(beginIndex);
        if (suffix.length() == 0) {
            return Collections.emptyList();
        }
        char c = suffix.charAt(0);
        char lower = Character.toLowerCase(c);
        String candidate = "" + lower + suffix.substring(1);
        return Arrays.asList(candidate, "_" + candidate);
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return false;
        }
        boolean present = method.isAnnotationPresent(annotationClass);
        if (present) {
            return true;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.isAnnotationPresent(parentClassMethod, annotationClass);
            }
            catch (NoSuchMethodException | SecurityException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.isAnnotationPresent(ifaceMethod, annotationClass);
            }
            catch (NoSuchMethodException | SecurityException exception) {
            }
        }
        return false;
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Class<?>[] interfaces;
        if (method == null) {
            return new Annotation[0][0];
        }
        Annotation[][] allParamAnnotations = method.getParameterAnnotations();
        boolean foundAnnotationsForAnyParameter = false;
        for (Annotation[] singleParamAnnotations : allParamAnnotations) {
            if (singleParamAnnotations.length <= 0) continue;
            foundAnnotationsForAnyParameter = true;
            break;
        }
        if (foundAnnotationsForAnyParameter) {
            return allParamAnnotations;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getParameterAnnotations(parentClassMethod);
            }
            catch (NoSuchMethodException | SecurityException parentClassMethod) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return Annotations.getParameterAnnotations(ifaceMethod);
            }
            catch (NoSuchMethodException | SecurityException exception) {
            }
        }
        return Annotations.noParamAnnotationsFor(method);
    }

    private static Annotation[][] noParamAnnotationsFor(Method method) {
        return new Annotation[method.getParameterTypes().length][0];
    }

    static class FieldEvaluator<T extends Annotation>
    extends Evaluator<T> {
        private final Field field;

        FieldEvaluator(Field field, T annotation) {
            super(annotation);
            this.field = field;
        }

        @Override
        public Object value(Object obj) {
            try {
                this.field.setAccessible(true);
                return this.field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new MetaModelException("illegal access of " + this.field, e);
            }
        }

        public Field getField() {
            return this.field;
        }
    }

    public static class MethodEvaluator<T extends Annotation>
    extends Evaluator<T> {
        private final Method method;

        MethodEvaluator(Method method, T annotation) {
            super(annotation);
            this.method = method;
        }

        @Override
        public Object value(Object obj) {
            try {
                return this.method.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                ThrowableExtensions.throwWithinIsisException(e, "Exception executing " + this.method);
                return null;
            }
            catch (IllegalAccessException e) {
                throw new MetaModelException("illegal access of " + this.method, e);
            }
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static abstract class Evaluator<T extends Annotation> {
        private final T annotation;

        protected Evaluator(T annotation) {
            this.annotation = annotation;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public abstract Object value(Object var1);
    }
}

