/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import com.google.common.collect.ImmutableList;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.lang.StringExtensions;

public enum FeatureType {
    OBJECT("Object"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            return Identifier.classIdentifier(type);
        }
    }
    ,
    PROPERTY("Property"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            return FeatureType.propertyOrCollectionIdentifierFor(type, method);
        }
    }
    ,
    COLLECTION("Collection"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            return FeatureType.propertyOrCollectionIdentifierFor(type, method);
        }
    }
    ,
    ACTION("Action"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            String fullMethodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            return Identifier.actionIdentifier((String)type.getName(), (String)fullMethodName, (Class[])parameterTypes);
        }
    }
    ,
    ACTION_PARAMETER_SCALAR("Scalar Parameter"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            return null;
        }
    }
    ,
    ACTION_PARAMETER_COLLECTION("Collection Parameter"){

        @Override
        public Identifier identifierFor(Class<?> type, Method method) {
            return null;
        }
    };

    public static final List<FeatureType> COLLECTIONS_ONLY;
    public static final List<FeatureType> COLLECTIONS_AND_ACTIONS;
    public static final List<FeatureType> ACTIONS_ONLY;
    public static final List<FeatureType> PARAMETERS_ONLY;
    public static final List<FeatureType> PROPERTIES_ONLY;
    public static final List<FeatureType> PROPERTIES_AND_ACTIONS;
    public static final List<FeatureType> OBJECTS_ONLY;
    public static final List<FeatureType> MEMBERS;
    public static final List<FeatureType> OBJECTS_AND_PROPERTIES;
    public static final List<FeatureType> PROPERTIES_AND_COLLECTIONS;
    public static final List<FeatureType> OBJECTS_AND_COLLECTIONS;
    public static final List<FeatureType> OBJECTS_AND_ACTIONS;
    public static final List<FeatureType> OBJECTS_PROPERTIES_AND_COLLECTIONS;
    public static final List<FeatureType> ACTIONS_AND_PARAMETERS;
    public static final List<FeatureType> EVERYTHING_BUT_PARAMETERS;
    public static final List<FeatureType> EVERYTHING;
    private final String name;

    private FeatureType(String name) {
        this.name = name;
    }

    private static Identifier propertyOrCollectionIdentifierFor(Class<?> type, Method method) {
        String capitalizedName = StringExtensions.asJavaBaseName(method.getName());
        String beanName = Introspector.decapitalize(capitalizedName);
        return Identifier.propertyOrCollectionIdentifier((String)type.getName(), (String)beanName);
    }

    public boolean isProperty() {
        return this == PROPERTY;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isAction() {
        return this == ACTION;
    }

    public boolean isActionParameter() {
        return this == ACTION_PARAMETER_SCALAR || this == ACTION_PARAMETER_COLLECTION;
    }

    public boolean isPropertyOrCollection() {
        return this.isProperty() || this.isCollection();
    }

    public abstract Identifier identifierFor(Class<?> var1, Method var2);

    public String toString() {
        return this.name;
    }

    static {
        COLLECTIONS_ONLY = ImmutableList.of((Object)((Object)COLLECTION));
        COLLECTIONS_AND_ACTIONS = ImmutableList.of((Object)((Object)COLLECTION), (Object)((Object)ACTION));
        ACTIONS_ONLY = ImmutableList.of((Object)((Object)ACTION));
        PARAMETERS_ONLY = ImmutableList.of((Object)((Object)ACTION_PARAMETER_SCALAR), (Object)((Object)ACTION_PARAMETER_COLLECTION));
        PROPERTIES_ONLY = ImmutableList.of((Object)((Object)PROPERTY));
        PROPERTIES_AND_ACTIONS = ImmutableList.of((Object)((Object)PROPERTY), (Object)((Object)ACTION));
        OBJECTS_ONLY = ImmutableList.of((Object)((Object)OBJECT));
        MEMBERS = ImmutableList.of((Object)((Object)PROPERTY), (Object)((Object)COLLECTION), (Object)((Object)ACTION));
        OBJECTS_AND_PROPERTIES = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)PROPERTY));
        PROPERTIES_AND_COLLECTIONS = ImmutableList.of((Object)((Object)PROPERTY), (Object)((Object)COLLECTION));
        OBJECTS_AND_COLLECTIONS = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)COLLECTION));
        OBJECTS_AND_ACTIONS = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)ACTION));
        OBJECTS_PROPERTIES_AND_COLLECTIONS = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)PROPERTY), (Object)((Object)COLLECTION));
        ACTIONS_AND_PARAMETERS = ImmutableList.of((Object)((Object)ACTION), (Object)((Object)ACTION_PARAMETER_SCALAR), (Object)((Object)ACTION_PARAMETER_COLLECTION));
        EVERYTHING_BUT_PARAMETERS = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)PROPERTY), (Object)((Object)COLLECTION), (Object)((Object)ACTION));
        EVERYTHING = ImmutableList.of((Object)((Object)OBJECT), (Object)((Object)PROPERTY), (Object)((Object)COLLECTION), (Object)((Object)ACTION), (Object)((Object)ACTION_PARAMETER_SCALAR), (Object)((Object)ACTION_PARAMETER_COLLECTION));
    }
}

