/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.url.UrlEncodingUtils;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.schema.common.v1.BookmarkObjectState;
import org.apache.isis.schema.common.v1.OidDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootOid
implements TypedOid,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RootOid.class);
    private static final long serialVersionUID = 1L;
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    private final ObjectSpecId objectSpecId;
    private final String identifier;
    private final Oid.State state;
    private Version version;
    private int cachedHashCode;

    public static RootOid createTransient(ObjectSpecId objectSpecId, String identifier) {
        return new RootOid(objectSpecId, identifier, Oid.State.TRANSIENT);
    }

    public static RootOid create(Bookmark bookmark) {
        return new RootOid(ObjectSpecId.of(bookmark.getObjectType()), bookmark.getIdentifier(), Oid.State.from(bookmark));
    }

    public static RootOid create(ObjectSpecId objectSpecId, String identifier) {
        return RootOid.create(objectSpecId, identifier, null);
    }

    public static RootOid create(ObjectSpecId objectSpecId, String identifier, Long versionSequence) {
        return RootOid.create(objectSpecId, identifier, versionSequence, null, null);
    }

    public static RootOid create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser) {
        return RootOid.create(objectSpecId, identifier, versionSequence, versionUser, null);
    }

    public static RootOid create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, Long versionUtcTimestamp) {
        return RootOid.create(objectSpecId, identifier, versionSequence, null, versionUtcTimestamp);
    }

    public static RootOid create(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser, Long versionUtcTimestamp) {
        return new RootOid(objectSpecId, identifier, Oid.State.PERSISTENT, Version.create(versionSequence, versionUser, versionUtcTimestamp));
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state) {
        this(objectSpecId, identifier, state, (Version)null);
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence) {
        this(objectSpecId, identifier, state, versionSequence, null, null);
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, String versionUser) {
        this(objectSpecId, identifier, state, versionSequence, versionUser, null);
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, Long versionUtcTimestamp) {
        this(objectSpecId, identifier, state, versionSequence, null, versionUtcTimestamp);
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state, Long versionSequence, String versionUser, Long versionUtcTimestamp) {
        this(objectSpecId, identifier, state, Version.create(versionSequence, versionUser, versionUtcTimestamp));
    }

    public RootOid(ObjectSpecId objectSpecId, String identifier, Oid.State state, Version version) {
        assert (objectSpecId != null);
        assert (identifier != null);
        assert (state != null);
        this.objectSpecId = objectSpecId;
        this.identifier = identifier;
        this.state = state;
        this.version = version;
        this.initialized();
    }

    private void initialized() {
        this.cacheState();
    }

    public RootOid(DataInputExtended input) throws IOException {
        String oidStr = input.readUTF();
        RootOid oid = OID_MARSHALLER.unmarshal(oidStr, RootOid.class);
        this.objectSpecId = oid.objectSpecId;
        this.identifier = oid.identifier;
        this.state = oid.state;
        this.version = oid.version;
        this.cacheState();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.enString());
    }

    public static RootOid deStringEncoded(String urlEncodedOidStr) {
        String oidStr = UrlEncodingUtils.urlDecode(urlEncodedOidStr);
        return RootOid.deString(oidStr);
    }

    public static RootOid deString(String oidStr) {
        return OID_MARSHALLER.unmarshal(oidStr, RootOid.class);
    }

    @Override
    public String enString() {
        return OID_MARSHALLER.marshal(this);
    }

    @Override
    public String enStringNoVersion() {
        return OID_MARSHALLER.marshalNoVersion(this);
    }

    @Override
    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isTransient() {
        return this.state.isTransient();
    }

    @Override
    public boolean isViewModel() {
        return this.state.isViewModel();
    }

    @Override
    public boolean isPersistent() {
        return this.state.isPersistent();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    public Bookmark asBookmark() {
        String objectType = this.state.asBookmarkObjectState().getCode() + this.getObjectSpecId().asString();
        String identifier = this.getIdentifier();
        return new Bookmark(objectType, identifier);
    }

    public OidDto asOidDto() {
        OidDto oidDto = new OidDto();
        oidDto.setType(this.getObjectSpecId().asString());
        oidDto.setId(this.getIdentifier());
        Bookmark.ObjectState objectState = this.state.asBookmarkObjectState();
        BookmarkObjectState bookmarkState = objectState.toBookmarkState();
        oidDto.setObjectState((BookmarkObjectState)(bookmarkState != BookmarkObjectState.PERSISTENT ? bookmarkState : null));
        return oidDto;
    }

    private void cacheState() {
        this.cachedHashCode = 17;
        this.cachedHashCode = 37 * this.cachedHashCode + this.objectSpecId.hashCode();
        this.cachedHashCode = 37 * this.cachedHashCode + this.identifier.hashCode();
        this.cachedHashCode = 37 * this.cachedHashCode + (this.isTransient() ? 0 : 1);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((RootOid)other);
    }

    public boolean equals(RootOid other) {
        return Objects.equal((Object)this.objectSpecId, (Object)other.getObjectSpecId()) && Objects.equal((Object)this.identifier, (Object)other.getIdentifier()) && Objects.equal((Object)this.isTransient(), (Object)other.isTransient());
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.enString();
    }
}

