/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public final class ParentedCollectionOid
implements Serializable,
Oid {
    private static final long serialVersionUID = 1L;
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    private final String name;
    private int cachedHashCode;
    private final RootOid parentOid;

    public ParentedCollectionOid(RootOid rootOid, OneToManyAssociation otma) {
        this(rootOid, otma.getId());
    }

    public ParentedCollectionOid(RootOid rootOid, String name) {
        Assert.assertNotNull("rootOid required", rootOid);
        this.parentOid = rootOid;
        this.name = name;
        this.cacheState();
    }

    public RootOid getRootOid() {
        return this.parentOid;
    }

    @Override
    public Version getVersion() {
        return this.parentOid.getVersion();
    }

    @Override
    public void setVersion(Version version) {
        this.parentOid.setVersion(version);
    }

    @Override
    public boolean isTransient() {
        return this.getRootOid().isTransient();
    }

    @Override
    public boolean isViewModel() {
        return this.getRootOid().isViewModel();
    }

    @Override
    public boolean isPersistent() {
        return this.getRootOid().isPersistent();
    }

    public static ParentedCollectionOid deString(String oidStr) {
        return OID_MARSHALLER.unmarshal(oidStr, ParentedCollectionOid.class);
    }

    @Override
    public String enString() {
        return OID_MARSHALLER.marshal(this);
    }

    @Override
    public String enStringNoVersion() {
        return OID_MARSHALLER.marshalNoVersion(this);
    }

    public ParentedCollectionOid(DataInputExtended inputStream) throws IOException {
        this(ParentedCollectionOid.deString(inputStream.readUTF()));
    }

    private ParentedCollectionOid(ParentedCollectionOid oid) throws IOException {
        this.parentOid = oid.getRootOid();
        this.name = oid.name;
    }

    @Override
    public void encode(DataOutputExtended outputStream) throws IOException {
        outputStream.writeUTF(this.enString());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.enString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((ParentedCollectionOid)other);
    }

    public boolean equals(ParentedCollectionOid other) {
        return Objects.equal((Object)other.getRootOid(), (Object)this.getRootOid()) && Objects.equal((Object)other.name, (Object)this.name);
    }

    public int hashCode() {
        this.cacheState();
        return this.cachedHashCode;
    }

    private void cacheState() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.getRootOid().hashCode();
        this.cachedHashCode = hashCode = 37 * hashCode + this.name.hashCode();
    }

    public ParentedCollectionOid asPersistent(RootOid newParentRootOid) {
        return new ParentedCollectionOid(newParentRootOid, this.name);
    }
}

