/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.mgr;

import java.util.concurrent.Callable;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerBase;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public interface AdapterManager
extends AdapterManagerBase {
    @Programmatic
    public ObjectAdapter getAdapterFor(Oid var1);

    @Programmatic
    public ObjectAdapter adapterFor(Object var1, ObjectAdapter var2, OneToManyAssociation var3);

    @Programmatic
    public ObjectAdapter mapRecreatedPojo(Oid var1, Object var2);

    @Programmatic
    public void removeAdapter(ObjectAdapter var1);

    public static enum ConcurrencyChecking {
        NO_CHECK,
        CHECK;

        private static ThreadLocal<ConcurrencyChecking> concurrencyChecking;

        @Programmatic
        public boolean isChecking() {
            return this == CHECK;
        }

        public static ConcurrencyChecking concurrencyCheckingFor(ActionSemantics.Of actionSemantics) {
            return actionSemantics.isSafeInNature() ? NO_CHECK : CHECK;
        }

        public static boolean isCurrentlyEnabled() {
            return concurrencyChecking.get().isChecking();
        }

        public static <T> T executeWithConcurrencyCheckingDisabled(Callable<T> callable) {
            ConcurrencyChecking prior = null;
            try {
                prior = ConcurrencyChecking.disable();
                T t = callable.call();
                return t;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                ConcurrencyChecking.reset(prior);
            }
        }

        public static ConcurrencyChecking disable() {
            ConcurrencyChecking prior = concurrencyChecking.get();
            concurrencyChecking.set(NO_CHECK);
            return prior;
        }

        public static void reset(ConcurrencyChecking prior) {
            if (prior == null) {
                return;
            }
            concurrencyChecking.set(prior);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void executeWithConcurrencyCheckingDisabled(Runnable runnable) {
            ConcurrencyChecking prior = concurrencyChecking.get();
            try {
                ConcurrencyChecking.disable();
                runnable.run();
            }
            finally {
                concurrencyChecking.set(prior);
            }
        }

        static {
            concurrencyChecking = new ThreadLocal<ConcurrencyChecking>(){

                @Override
                protected ConcurrencyChecking initialValue() {
                    return CHECK;
                }
            };
        }
    }
}

