/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.matchers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.hamcrest.core.StringStartsWith;

public final class IsisMatchers {
    private IsisMatchers() {
    }

    @Factory
    public static Matcher<String> containsStripNewLines(String expected) {
        final String strippedExpected = StringExtensions.stripNewLines(expected);
        return new StringContains(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringExtensions.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) containing").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static Matcher<String> equalToStripNewLines(String expected) {
        final String strippedExpected = StringExtensions.stripNewLines(expected);
        return new IsEqual<String>(strippedExpected){

            public boolean matches(Object actualObj) {
                String actual = (String)actualObj;
                return super.matches((Object)StringExtensions.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) equal to").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static StringStartsWith startsWithStripNewLines(String expected) {
        final String strippedExpected = StringExtensions.stripNewLines(expected);
        return new StringStartsWith(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringExtensions.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) starting with").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static Matcher<String> endsWithStripNewLines(String expected) {
        final String strippedExpected = StringExtensions.stripNewLines(expected);
        return new StringEndsWith(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringExtensions.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) ending with").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static <T> Matcher<T> anInstanceOf(final Class<T> expected) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T actual) {
                return expected.isAssignableFrom(actual.getClass());
            }

            public void describeTo(Description description) {
                description.appendText("an instance of ").appendValue((Object)expected);
            }
        };
    }

    @Factory
    public static Matcher<String> nonEmptyString() {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String str) {
                return str != null && str.length() > 0;
            }

            public void describeTo(Description description) {
                description.appendText("a non empty string");
            }
        };
    }

    @Factory
    public static Matcher<String> nonEmptyStringOrNull() {
        return CoreMatchers.anyOf((Matcher)CoreMatchers.nullValue(String.class), IsisMatchers.nonEmptyString());
    }

    @Factory
    public static Matcher<List<?>> containsElementThat(final Matcher<?> elementMatcher) {
        return new TypeSafeMatcher<List<?>>(){

            public boolean matchesSafely(List<?> list) {
                for (Object o : list) {
                    if (!elementMatcher.matches(o)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("contains element that ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }
        };
    }

    @Factory
    public static <T extends Comparable<T>> Matcher<T> greaterThan(T c) {
        return Matchers.greaterThan(c);
    }

    @Factory
    public static Matcher<Class<?>> classEqualTo(Class<?> operand) {
        class ClassEqualsMatcher
        extends TypeSafeMatcher<Class<?>> {
            private final Class<?> clazz;

            public ClassEqualsMatcher(Class<?> clazz) {
                this.clazz = clazz;
            }

            public boolean matchesSafely(Class<?> arg) {
                return this.clazz == arg;
            }

            public void describeTo(Description description) {
                description.appendValue(this.clazz);
            }
        }
        return new ClassEqualsMatcher(operand);
    }

    @Factory
    public static Matcher<File> existsAndNotEmpty() {
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description arg0) {
                arg0.appendText("exists and is not empty");
            }

            public boolean matchesSafely(File f) {
                return f.exists() && f.length() > 0L;
            }
        };
    }

    @Factory
    public static Matcher<String> matches(final String regex) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("string matching " + regex);
            }

            public boolean matchesSafely(String str) {
                return str.matches(regex);
            }
        };
    }

    @Factory
    public static <X> Matcher<Class<X>> anySubclassOf(final Class<X> cls) {
        return new TypeSafeMatcher<Class<X>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("is subclass of ").appendText(cls.getName());
            }

            public boolean matchesSafely(Class<X> item) {
                return cls.isAssignableFrom(item);
            }
        };
    }

    @Factory
    public static <T> Matcher<List<T>> sameContentsAs(final List<T> expected) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description description) {
                description.appendText("same sequence as " + expected);
            }

            public boolean matchesSafely(List<T> actual) {
                return actual.containsAll(expected) && expected.containsAll(actual);
            }
        };
    }

    @Factory
    public static <T> Matcher<List<T>> listContaining(final T t) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("list containing ").appendValue(t);
            }

            public boolean matchesSafely(List<T> arg0) {
                return arg0.contains(t);
            }
        };
    }

    @Factory
    public static <T> Matcher<List<T>> listContainingAll(final T ... items) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("has items ").appendValue((Object)items);
            }

            public boolean matchesSafely(List<T> arg0) {
                return arg0.containsAll(Arrays.asList(items));
            }
        };
    }

    @Factory
    public static Matcher<List<Object>> containsObjectOfType(final Class<?> cls) {
        return new TypeSafeMatcher<List<Object>>(){

            public void describeTo(Description desc) {
                desc.appendText("contains instance of type " + cls.getName());
            }

            public boolean matchesSafely(List<Object> items) {
                for (Object object : items) {
                    if (!cls.isAssignableFrom(object.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Factory
    public static Matcher<String> startsWith(final String expected) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText(" starts with '" + expected + "'");
            }

            public boolean matchesSafely(String actual) {
                return actual.startsWith(expected);
            }
        };
    }

    @Factory
    public static Matcher<String> contains(final String expected) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText(" contains '" + expected + "'");
            }

            public boolean matchesSafely(String actual) {
                return actual.contains(expected);
            }
        };
    }

    @Factory
    public static Matcher<File> equalsFile(File file) throws IOException {
        final String canonicalPath = file.getCanonicalPath();
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description arg0) {
                arg0.appendText("file '" + canonicalPath + "'");
            }

            public boolean matchesSafely(File arg0) {
                try {
                    return arg0.getCanonicalPath().equals(canonicalPath);
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }
}

