/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.isis.applib.util.Enums;

public final class StringExtensions {
    static final char SPACE = ' ';
    private static final char CARRIAGE_RETURN = '\n';
    private static final char LINE_FEED = '\r';
    public static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;

    private StringExtensions() {
    }

    public static String asNaturalName2(String name) {
        int length;
        int idx = name.lastIndexOf("$");
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        if ((length = name.length()) <= 1) {
            return name.toUpperCase();
        }
        StringBuilder naturalName = new StringBuilder(length);
        char character = Character.toUpperCase(name.charAt(0));
        naturalName.append(character);
        char nextCharacter = name.charAt(1);
        for (int pos = 2; pos < length; ++pos) {
            char previousCharacter = character;
            character = nextCharacter;
            nextCharacter = name.charAt(pos);
            if (previousCharacter != ' ') {
                if (Character.isUpperCase(character) && !Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isUpperCase(character) && Character.isLowerCase(nextCharacter) && Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isDigit(character) && !Character.isDigit(previousCharacter)) {
                    naturalName.append(' ');
                }
            }
            naturalName.append(character);
        }
        naturalName.append(nextCharacter);
        return naturalName.toString();
    }

    public static String asNaturalName(String extendee) {
        int pos;
        for (pos = 0; pos < extendee.length() && Character.isLowerCase(extendee.charAt(pos)); ++pos) {
        }
        if (pos == extendee.length()) {
            return "invalid name";
        }
        return StringExtensions.naturalized(extendee, pos);
    }

    public static String asNaturalized(String extendee) {
        return StringExtensions.naturalized(extendee, 0);
    }

    private static String naturalized(String name, int startingPosition) {
        if (name.length() <= startingPosition) {
            throw new IllegalArgumentException("string shorter than starting position provided");
        }
        StringBuffer s = new StringBuffer(name.length() - startingPosition);
        for (int j = startingPosition; j < name.length(); ++j) {
            if (j > startingPosition && StringExtensions.isStartOfNewWord(name.charAt(j), name.charAt(j - 1))) {
                s.append(' ');
            }
            if (j == startingPosition) {
                s.append(Character.toUpperCase(name.charAt(j)));
                continue;
            }
            s.append(name.charAt(j));
        }
        String str = s.toString();
        return str;
    }

    private static boolean isStartOfNewWord(char c, char previousChar) {
        return Character.isUpperCase(c) || Character.isDigit(c) && !Character.isDigit(previousChar);
    }

    public static String asSimpleName(String extendee) {
        int lastDot = extendee.lastIndexOf(46);
        if (lastDot == -1) {
            return extendee;
        }
        if (lastDot == extendee.length() - 1) {
            throw new IllegalArgumentException("Name cannot end in '.'");
        }
        return extendee.substring(lastDot + 1);
    }

    public static String asCamel(String extendee) {
        StringBuffer b = new StringBuffer(extendee.length());
        StringTokenizer t = new StringTokenizer(extendee);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public static String asCamelLowerFirst(String extendee) {
        StringBuffer b = new StringBuffer(extendee.length());
        StringTokenizer t = new StringTokenizer(extendee);
        b.append(StringExtensions.asLowerFirst(t.nextToken()));
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1).toLowerCase());
        }
        return b.toString();
    }

    public static String asLowerDashed(String extendee) {
        return extendee.toLowerCase().replaceAll("\\s+", "-");
    }

    public static String asPascal(String extendee) {
        return StringExtensions.capitalize(StringExtensions.asCamel(extendee));
    }

    public static String asMemberIdFor(String extendee) {
        return StringExtensions.asLowerFirst(StringExtensions.asCamel(extendee));
    }

    public static String capitalize(String extendee) {
        if (extendee == null || extendee.length() == 0) {
            return extendee;
        }
        if (extendee.length() == 1) {
            return extendee.toUpperCase();
        }
        return Character.toUpperCase(extendee.charAt(0)) + extendee.substring(1);
    }

    public static String asLowerFirst(String extendee) {
        if (Strings.isNullOrEmpty((String)extendee)) {
            return extendee;
        }
        if (extendee.length() == 1) {
            return extendee.toLowerCase();
        }
        return extendee.substring(0, 1).toLowerCase() + extendee.substring(1);
    }

    public static String asFirstWord(String extendee) {
        String[] split = extendee.split(" ");
        return split[0];
    }

    public static boolean in(String extendee, String[] strings) {
        for (String strCandidate : strings) {
            if (!strCandidate.equals(extendee)) continue;
            return true;
        }
        return false;
    }

    public static String combinePaths(String extendee, String ... furtherPaths) {
        StringBuilder pathBuf = new StringBuilder(extendee);
        for (String furtherPath : furtherPaths) {
            if (pathBuf.charAt(pathBuf.length() - 1) != File.separatorChar) {
                pathBuf.append(File.separatorChar);
            }
            pathBuf.append(furtherPath);
        }
        return pathBuf.toString();
    }

    public static List<String> splitOnCommas(String commaSeparatedExtendee) {
        if (commaSeparatedExtendee == null) {
            return null;
        }
        String removeLeadingWhiteSpace = StringExtensions.removeLeadingWhiteSpace(commaSeparatedExtendee);
        if (removeLeadingWhiteSpace.length() == 0) {
            return Collections.emptyList();
        }
        String[] splitAsArray = removeLeadingWhiteSpace.split("\\W*,\\W*");
        return Arrays.asList(splitAsArray);
    }

    public static String lineSeparated(String extendee) {
        StringBuilder buf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        boolean lastWasLineFeed = false;
        for (char c : extendee.toCharArray()) {
            boolean isCarriageReturn;
            boolean isLineFeed = c == '\r';
            boolean bl = isCarriageReturn = c == '\n';
            if (isCarriageReturn) {
                buf.append(lineSeparator);
                lastWasLineFeed = false;
                continue;
            }
            if (lastWasLineFeed) {
                buf.append('\r');
            }
            if (isLineFeed) {
                lastWasLineFeed = true;
                continue;
            }
            buf.append(c);
            lastWasLineFeed = false;
        }
        if (lastWasLineFeed) {
            buf.append('\r');
        }
        return buf.toString();
    }

    public static String removeTabs(String extendee) {
        if (extendee.indexOf(9) == -1) {
            return extendee;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < extendee.length(); ++i) {
            if (extendee.charAt(i) == '\t') continue;
            buf.append(extendee.charAt(i));
        }
        return buf.toString();
    }

    public static String removeLeadingWhiteSpace(String extendee) {
        if (extendee == null) {
            return null;
        }
        return extendee.replaceAll("^\\W*", EMPTY);
    }

    public static String stripNewLines(String extendee) {
        return extendee.replaceAll("[\r\n]", EMPTY);
    }

    public static String stripLeadingSlash(String extendee) {
        if (!extendee.startsWith("/")) {
            return extendee;
        }
        if (extendee.length() < 2) {
            return EMPTY;
        }
        return extendee.substring(1);
    }

    public static String normalized(String extendee) {
        if (extendee == null) {
            return null;
        }
        return extendee.replaceAll("\\s+", " ");
    }

    public static String removePrefix(String extendee, String prefix) {
        return extendee.startsWith(prefix) ? extendee.substring(prefix.length()) : extendee;
    }

    public static String enumTitle(String enumName) {
        return Enums.getFriendlyNameOf((String)enumName);
    }

    public static String enumDeTitle(String enumFriendlyName) {
        return Enums.getEnumNameFromFriendly((String)enumFriendlyName);
    }

    public static String toAbbreviation(String extendee) {
        StringBuilder buf = new StringBuilder();
        for (char c : extendee.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String repeat(String extendee, int repeat) {
        if (extendee == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = extendee.length();
        if (repeat == 1 || inputLength == 0) {
            return extendee;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringExtensions.padding(repeat, extendee.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = extendee.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = extendee.charAt(0);
                char ch1 = extendee.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(extendee);
        }
        return buf.toString();
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static boolean startsWith(String extendee, String prefix) {
        int length = prefix.length();
        if (length >= extendee.length()) {
            return false;
        }
        char startingCharacter = extendee.charAt(length);
        return extendee.startsWith(prefix) && Character.isUpperCase(startingCharacter);
    }

    public static String combinePath(String extendee, String suffix) {
        if (Strings.isNullOrEmpty((String)extendee) && Strings.isNullOrEmpty((String)suffix)) {
            return EMPTY;
        }
        if (Strings.isNullOrEmpty((String)extendee)) {
            return suffix;
        }
        if (Strings.isNullOrEmpty((String)suffix)) {
            return extendee;
        }
        if (extendee.endsWith("/") || suffix.startsWith("/")) {
            return extendee + suffix;
        }
        return extendee + "/" + suffix;
    }

    public static String asJavaBaseName(String javaName) {
        int pos;
        int len = javaName.length();
        for (pos = 0; pos < len && javaName.charAt(pos) != '_' && Character.isLowerCase(javaName.charAt(pos)); ++pos) {
        }
        if (pos >= len) {
            return EMPTY;
        }
        if (javaName.charAt(pos) == '_') {
            ++pos;
        }
        if (pos >= len) {
            return EMPTY;
        }
        String baseName = javaName.substring(pos);
        char firstChar = baseName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return Character.toUpperCase(firstChar) + baseName.substring(1);
        }
        return baseName;
    }

    public static String asJavaBaseNameStripAccessorPrefixIfRequired(String javaNameExtendee) {
        if (javaNameExtendee.startsWith("is") || javaNameExtendee.startsWith("get")) {
            return StringExtensions.asJavaBaseName(javaNameExtendee);
        }
        return StringExtensions.asCapitalizedName(javaNameExtendee);
    }

    public static String asCapitalizedName(String extendee) {
        return Character.toUpperCase(extendee.charAt(0)) + extendee.substring(1);
    }

    public static String asPluralName(String extendee) {
        String pluralName = extendee.endsWith("y") ? extendee.substring(0, extendee.length() - 1) + "ies" : (extendee.endsWith("s") || extendee.endsWith("x") ? extendee + "es" : extendee + 's');
        return pluralName;
    }

    public static String toCamelCase(String extendee) {
        String nameLower = extendee.toLowerCase();
        StringBuilder buf = new StringBuilder();
        boolean capitalizeNext = false;
        for (int i = 0; i < nameLower.length(); ++i) {
            char ch = nameLower.charAt(i);
            if (ch == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buf.append(Character.toUpperCase(ch));
            } else {
                buf.append(ch);
            }
            capitalizeNext = false;
        }
        return buf.toString();
    }
}

