/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.base.Joiner;
import java.util.Properties;

public class PropertiesExtensions {
    private PropertiesExtensions() {
    }

    public static Properties subset(Properties extendee, String ... prefix) {
        String prefices = Joiner.on((String)".").join((Object[])prefix);
        return PropertiesExtensions.subsetOf(extendee, prefices + ".");
    }

    private static Properties subsetOf(Properties extendee, String prefix) {
        int prefixLength = prefix.length();
        Properties subsetProperties = new Properties();
        for (Object keyObj : extendee.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(prefix)) continue;
            String keySuffix = key.substring(prefixLength);
            subsetProperties.put(keySuffix, extendee.get(key));
        }
        return subsetProperties;
    }
}

