/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class MethodUtil {
    private MethodUtil() {
    }

    public static void invoke(List<Method> methods, Object object) {
        for (Method method : methods) {
            MethodExtensions.invoke(method, object);
        }
    }

    public static Method removeMethod(List<Method> methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        int idx = MethodUtil.findMethodIndex(methods, methodScope, name, returnType, paramTypes);
        if (idx != -1) {
            Method method = methods.get(idx);
            methods.set(idx, null);
            return method;
        }
        return null;
    }

    private static int findMethodIndex(List<Method> methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        int idx = -1;
        block0: for (int i = 0; i < methods.size(); ++i) {
            Method method;
            int modifiers;
            if (methods.get(i) == null || !Modifier.isPublic(modifiers = (method = methods.get(i)).getModifiers()) || !MethodUtil.inScope(method, methodScope) || !method.getName().equals(name) || returnType != null && returnType != method.getReturnType()) continue;
            if (paramTypes != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (paramTypes.length != parameterTypes.length) continue;
                for (int c = 0; c < paramTypes.length; ++c) {
                    if (paramTypes[c] != null && paramTypes[c] != parameterTypes[c]) continue block0;
                }
            }
            idx = i;
            break;
        }
        return idx;
    }

    public static boolean inScope(Method extendee, MethodScope methodScope) {
        boolean isStatic = MethodExtensions.isStatic(extendee);
        return isStatic && methodScope == MethodScope.CLASS || !isStatic && methodScope == MethodScope.OBJECT;
    }

    public static List<Method> removeMethods(List<Method> methods, MethodScope forClass, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        ArrayList<Method> validMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            if (method == null || !MethodUtil.inScope(method, forClass)) continue;
            boolean goodPrefix = method.getName().startsWith(prefix);
            boolean goodCount = method.getParameterTypes().length == paramCount;
            Class<?> type = method.getReturnType();
            boolean goodReturn = ClassExtensions.isCompatibleAsReturnType(returnType, canBeVoid, type);
            if (!goodPrefix || !goodCount || !goodReturn) continue;
            validMethods.add(method);
            methods.set(i, null);
        }
        return validMethods;
    }
}

