/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;

public class MethodExtensions {
    private MethodExtensions() {
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Object invoke(Method method, Object object) {
        Object[] parameters = MethodExtensions.getNullOrDefaultArgs(method);
        return MethodExtensions.invoke(method, object, parameters);
    }

    public static Object invoke(Method method, Object object, Object[] arguments) {
        try {
            Object[] defaultAnyPrimitive = MethodExtensions.defaultAnyPrimitive(method.getParameterTypes(), arguments);
            return method.invoke(object, defaultAnyPrimitive);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            ThrowableExtensions.throwWithinIsisException(e, "Exception executing " + method);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException("illegal access of " + method, e);
        }
    }

    private static Object[] defaultAnyPrimitive(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes == null || arguments == null || parameterTypes.length != arguments.length) {
            return arguments;
        }
        Object[] argumentsWithPrimitivesDefaulted = new Object[arguments.length];
        for (int i = 0; i < argumentsWithPrimitivesDefaulted.length; ++i) {
            argumentsWithPrimitivesDefaulted[i] = MethodExtensions.valueIfPrimitiveThenDefaulted(parameterTypes[i], arguments[i]);
        }
        return argumentsWithPrimitivesDefaulted;
    }

    private static Object valueIfPrimitiveThenDefaulted(Class<?> cls, Object argument) {
        if (argument != null) {
            return argument;
        }
        if (!cls.isPrimitive()) {
            return argument;
        }
        return ClassUtil.defaultByPrimitiveClass.get(cls);
    }

    public static Object invokeStatic(Method method, Object[] parameters) {
        return MethodExtensions.invoke(method, null, parameters);
    }

    public static Object invokeStatic(Method method) {
        return MethodExtensions.invoke(method, null, MethodExtensions.getNullOrDefaultArgs(method));
    }

    public static Object[] getNullOrDefaultArgs(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] parameters = new Object[paramTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = ClassExtensions.getNullOrDefault(paramTypes[i]);
        }
        return parameters;
    }
}

