/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassUtil;

public final class ClassExtensions {
    private ClassExtensions() {
    }

    public static Object newInstance(Class<?> extendee, Class<?> constructorParamType, Object constructorArg) {
        return ClassExtensions.newInstance(extendee, new Class[]{constructorParamType}, new Object[]{constructorArg});
    }

    public static Object newInstance(Class<?> extendee, Class<?>[] constructorParamTypes, Object[] constructorArgs) {
        try {
            try {
                Constructor<?> constructor = extendee.getConstructor(constructorParamTypes);
                return constructor.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Constructor<?> constructor = extendee.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IsisException(e);
                }
            }
        }
        catch (SecurityException ex) {
            throw new IsisException(ex);
        }
        catch (IllegalArgumentException e) {
            throw new IsisException(e);
        }
        catch (InstantiationException e) {
            throw new IsisException(e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException(e);
        }
        catch (InvocationTargetException e) {
            throw new IsisException(e);
        }
    }

    public static String getSuperclass(Class<?> extendee) {
        Class<?> superType = extendee.getSuperclass();
        if (superType == null) {
            return null;
        }
        return superType.getName();
    }

    public static boolean isAbstract(Class<?> extendee) {
        return Modifier.isAbstract(extendee.getModifiers());
    }

    public static boolean isFinal(Class<?> extendee) {
        return Modifier.isFinal(extendee.getModifiers());
    }

    public static boolean isPublic(Class<?> extendee) {
        return Modifier.isPublic(extendee.getModifiers());
    }

    public static boolean isJavaClass(Class<?> extendee) {
        String className = extendee.getName();
        return className.startsWith("java.") || extendee.getName().startsWith("sun.");
    }

    static Class<?> implementingClassOrNull(Class<?> extendee, Class<?> requiredClass, Class<?> constructorParamType) {
        if (extendee == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(extendee)) {
            return null;
        }
        try {
            extendee.getConstructor(constructorParamType);
        }
        catch (NoSuchMethodException ex) {
            try {
                extendee.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        int modifiers = extendee.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        return extendee;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterClass) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterClass);
    }

    public static Method getMethodElseNull(Class<?> clazz, String methodName, Class<?> ... parameterClass) {
        try {
            return clazz.getMethod(methodName, parameterClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method findMethodElseNull(Class<?> clazz, String[] candidateMethodNames, Class<?> ... parameterClass) {
        for (String candidateMethodName : candidateMethodNames) {
            Method method = ClassExtensions.getMethodElseNull(clazz, candidateMethodName, parameterClass);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Properties resourceProperties(Class<?> extendee, String suffix) {
        try {
            URL url = Resources.getResource(extendee, (String)(extendee.getSimpleName() + suffix));
            ByteSource byteSource = Resources.asByteSource((URL)url);
            Properties properties = new Properties();
            properties.load(byteSource.openStream());
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String resourceContent(Class<?> cls, String suffix) throws IOException {
        String resourceName = cls.getSimpleName() + suffix;
        return ClassExtensions.resourceContentOf(cls, resourceName);
    }

    public static String resourceContentOf(Class<?> cls, String resourceName) throws IOException {
        URL url = Resources.getResource(cls, (String)resourceName);
        return Resources.toString((URL)url, (Charset)Charset.defaultCharset());
    }

    public static boolean exists(Class<?> cls, String resourceName) {
        URL url = Resources.getResource(cls, (String)resourceName);
        return url != null;
    }

    public static Class<?> asWrapped(Class<?> primitiveClassExtendee) {
        return ClassUtil.wrapperClasses.get(primitiveClassExtendee);
    }

    public static Class<? extends Object> asWrappedIfNecessary(Class<?> cls) {
        return cls.isPrimitive() ? ClassExtensions.asWrapped(cls) : cls;
    }

    public static Object toDefault(Class<?> extendee) {
        if (!extendee.isPrimitive()) {
            return null;
        }
        return ClassUtil.defaultByPrimitiveClass.get(extendee);
    }

    public static Object getNullOrDefault(Class<?> type) {
        return ClassUtil.defaultByPrimitiveType.get(type);
    }

    public static boolean isCompatibleAsReturnType(Class<?> returnTypeExtendee, boolean canBeVoid, Class<?> type) {
        if (returnTypeExtendee == null) {
            return true;
        }
        if (canBeVoid && type == Void.TYPE) {
            return true;
        }
        if (type.isPrimitive()) {
            return returnTypeExtendee.isAssignableFrom(ClassUtil.wrapperClasses.get(type));
        }
        return returnTypeExtendee.isAssignableFrom(type);
    }
}

