/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassExtensions;

public final class ArrayExtensions {
    private ArrayExtensions() {
    }

    static Object[] convertPrimitiveToObjectArray(Object extendee, Class<?> arrayType) {
        Object[] convertedArray;
        try {
            Class<?> wrapperClass = ClassExtensions.asWrapped(arrayType);
            Constructor<?> constructor = wrapperClass.getConstructor(String.class);
            int len = Array.getLength(extendee);
            convertedArray = (Object[])Array.newInstance(wrapperClass, len);
            for (int i = 0; i < len; ++i) {
                convertedArray[i] = constructor.newInstance(Array.get(extendee, i).toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IsisException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IsisException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IsisException(e);
        }
        catch (InstantiationException e) {
            throw new IsisException(e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException(e);
        }
        catch (InvocationTargetException e) {
            throw new IsisException(e);
        }
        return convertedArray;
    }

    public static Object[] asCharToCharacterArray(Object extendee) {
        char[] original = (char[])extendee;
        int len = original.length;
        Object[] converted = new Character[len];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Character.valueOf(original[i]);
        }
        return converted;
    }

    public static <T> T[] combine(T[] ... arrays) {
        ArrayList combinedList = Lists.newArrayList();
        for (T[] array : arrays) {
            Collections.addAll(combinedList, array);
        }
        return combinedList.toArray(arrays[0]);
    }

    public static <T> T[] appendT(T[] array, T obj) {
        ArrayList combinedList = Lists.newArrayList();
        combinedList.add(obj);
        Collections.addAll(combinedList, array);
        return combinedList.toArray(array);
    }

    public static String[] append(String[] extendee, String ... moreArgs) {
        ArrayList argList = Lists.newArrayList();
        argList.addAll(Arrays.asList(extendee));
        argList.addAll(Arrays.asList(moreArgs));
        return argList.toArray(new String[0]);
    }

    public static List<String> mergeToList(String[] extendee, String[] array2) {
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayExtensions.addNoDuplicates(extendee, prefixes);
        ArrayExtensions.addNoDuplicates(array2, prefixes);
        return prefixes;
    }

    static void addNoDuplicates(String[] array, List<String> list) {
        for (int i = 0; i < array.length; ++i) {
            if (list.contains(array[i])) continue;
            list.add(array[i]);
        }
    }

    public static List<Object> asListFlattened(Object[] objectArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : objectArray) {
            if (Collection.class.isAssignableFrom(element.getClass())) {
                Collection collection = (Collection)element;
                list.addAll(ArrayExtensions.asListFlattened(collection.toArray()));
                continue;
            }
            list.add(element);
        }
        return list;
    }

    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static String commaSeparatedClassNames(List<Object> objects) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Object object : objects) {
            if (i++ > 0) {
                buf.append(',');
            }
            buf.append(object.getClass().getName());
        }
        return buf.toString();
    }

    public static String asSemicolonDelimitedStr(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String message : list) {
            if (list.size() > 1) {
                buf.append("; ");
            }
            buf.append(message);
        }
        return buf.toString();
    }

    public static List<Class<?>> toClasses(List<Object> objectList) {
        ArrayList classList = new ArrayList();
        for (Object service : objectList) {
            classList.add(service.getClass());
        }
        return classList;
    }
}

