/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    public static Throwable getCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            for (String methodName : CAUSE_METHOD_NAMES) {
                if (methodName != null && (cause = ExceptionUtils.getCauseUsingMethodName(throwable, methodName)) != null) break;
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method;
        try {
            method = throwable.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            return null;
        }
        if (!Throwable.class.isAssignableFrom(method.getReturnType())) {
            return null;
        }
        try {
            return (Throwable)method.invoke((Object)throwable, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ignored) {
            return null;
        }
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        for (String causeMethodName : CAUSE_METHOD_NAMES) {
            try {
                Method method = cls.getMethod(causeMethodName, null);
                if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List list = ExceptionUtils.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    public static List getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = ExceptionUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (ExceptionUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    static {
        Method causeMethod;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            causeMethod = null;
        }
        THROWABLE_CAUSE_METHOD = causeMethod;
    }
}

