/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.configbuilder;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;

public class PrimerForEnvironmentVariableISIS_OPTS
implements IsisConfigurationBuilder.Primer {
    public static final String OPT_ENV = "ISIS_OPTS";
    public static final String SEPARATOR_ENV = "ISIS_OPTS_SEPARATOR";
    public static final String SEPARATOR_DEFAULT = "||";

    @Override
    public void prime(IsisConfigurationBuilder builder) {
        String separator = this.determineSeparator();
        String optEnv = OPT_ENV;
        String env = this.getEnv(OPT_ENV);
        for (Map.Entry<String, String> entry : PrimerForEnvironmentVariableISIS_OPTS.fromEnv(env, separator).entrySet()) {
            String envVarName = entry.getKey();
            String envVarValue = entry.getValue();
            builder.put(envVarName, envVarValue);
        }
    }

    String getEnv(String optEnv) {
        return System.getenv(optEnv);
    }

    private String determineSeparator() {
        String separator = this.getEnv(SEPARATOR_ENV);
        if (separator != null) {
            return separator;
        }
        return SEPARATOR_DEFAULT;
    }

    private static Map<String, String> fromEnv(String env, String separator) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (env != null) {
            List keyAndValues = Splitter.on((String)separator).splitToList((CharSequence)env);
            for (String keyAndValue : keyAndValues) {
                ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)"=").splitToList((CharSequence)keyAndValue));
                if (parts.size() < 2) continue;
                String key = (String)parts.get(0);
                parts.remove(0);
                String value = Joiner.on((String)"=").join((Iterable)parts);
                map.put(key, value);
            }
        }
        return map;
    }
}

